package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonInclude(NON_NULL)
public class MsMataDataBatchQueryRequest {
  @JsonProperty("objCode")
  private String objCode = null;

  @JsonProperty("objType")
  private String objType = null;

  @JsonProperty("groupId")
  private Long groupId = null;

  @JsonProperty("filedNameList")
  private List<String> filedNameList = new ArrayList<String>();

  @JsonIgnore
  public MsMataDataBatchQueryRequest objCode(String objCode) {
    this.objCode = objCode;
    return this;
  }

   /**
   * 业务对象编码
   * @return objCode
  **/
  @ApiModelProperty(value = "业务对象编码")
  public String getObjCode() {
    return objCode;
  }

  public void setObjCode(String objCode) {
    this.objCode = objCode;
  }

  @JsonIgnore
  public MsMataDataBatchQueryRequest objType(String objType) {
    this.objType = objType;
    return this;
  }

   /**
   * 业务对象类型
   * @return objType
  **/
  @ApiModelProperty(value = "业务对象类型")
  public String getObjType() {
    return objType;
  }

  public void setObjType(String objType) {
    this.objType = objType;
  }

  @JsonIgnore
  public MsMataDataBatchQueryRequest groupId(Long groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 集团ID
   * @return groupId
  **/
  @ApiModelProperty(value = "集团ID")
  public Long getGroupId() {
    return groupId;
  }

  public void setGroupId(Long groupId) {
    this.groupId = groupId;
  }

  @JsonIgnore
  public MsMataDataBatchQueryRequest filedNameList(List<String> filedNameList) {
    this.filedNameList = filedNameList;
    return this;
  }

  public MsMataDataBatchQueryRequest addFiledNameListItem(String filedNameListItem) {
    this.filedNameList.add(filedNameListItem);
    return this;
  }

   /**
   * 元数据列表
   * @return filedNameList
  **/
  @ApiModelProperty(value = "元数据列表")
  public List<String> getFiledNameList() {
    return filedNameList;
  }

  public void setFiledNameList(List<String> filedNameList) {
    this.filedNameList = filedNameList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsMataDataBatchQueryRequest mataDataBatchQueryRequest = (MsMataDataBatchQueryRequest) o;
    return Objects.equals(this.objCode, mataDataBatchQueryRequest.objCode) &&
        Objects.equals(this.objType, mataDataBatchQueryRequest.objType) &&
        Objects.equals(this.groupId, mataDataBatchQueryRequest.groupId) &&
        Objects.equals(this.filedNameList, mataDataBatchQueryRequest.filedNameList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(objCode, objType, groupId, filedNameList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsMataDataBatchQueryRequest {\n");
    
    sb.append("    objCode: ").append(toIndentedString(objCode)).append("\n");
    sb.append("    objType: ").append(toIndentedString(objType)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    filedNameList: ").append(toIndentedString(filedNameList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
