package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.seller.config.client.model.MsCommonUserInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonInclude(NON_NULL)
public class MsMataDataDeleteRequestWithUserInfo {
  @JsonProperty("items")
  private List<Long> items = new ArrayList<Long>();

  @JsonProperty("userInfo")
  private MsCommonUserInfo userInfo = null;

  @JsonIgnore
  public MsMataDataDeleteRequestWithUserInfo items(List<Long> items) {
    this.items = items;
    return this;
  }

  public MsMataDataDeleteRequestWithUserInfo addItemsItem(Long itemsItem) {
    this.items.add(itemsItem);
    return this;
  }

   /**
   * Get items
   * @return items
  **/
  @ApiModelProperty(value = "")
  public List<Long> getItems() {
    return items;
  }

  public void setItems(List<Long> items) {
    this.items = items;
  }

  @JsonIgnore
  public MsMataDataDeleteRequestWithUserInfo userInfo(MsCommonUserInfo userInfo) {
    this.userInfo = userInfo;
    return this;
  }

   /**
   * 用户信息
   * @return userInfo
  **/
  @ApiModelProperty(value = "用户信息")
  public MsCommonUserInfo getUserInfo() {
    return userInfo;
  }

  public void setUserInfo(MsCommonUserInfo userInfo) {
    this.userInfo = userInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsMataDataDeleteRequestWithUserInfo mataDataDeleteRequestWithUserInfo = (MsMataDataDeleteRequestWithUserInfo) o;
    return Objects.equals(this.items, mataDataDeleteRequestWithUserInfo.items) &&
        Objects.equals(this.userInfo, mataDataDeleteRequestWithUserInfo.userInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(items, userInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsMataDataDeleteRequestWithUserInfo {\n");
    
    sb.append("    items: ").append(toIndentedString(items)).append("\n");
    sb.append("    userInfo: ").append(toIndentedString(userInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
