package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 元数据对象查询请求
 */
@ApiModel(description = "元数据对象查询请求")

@JsonInclude(NON_NULL)
public class MsMataDataQueryRequest {
  @JsonProperty("objId")
  private Long objId = null;

  @JsonProperty("objCode")
  private String objCode = null;

  @JsonProperty("objName")
  private String objName = null;

  @JsonProperty("objType")
  private String objType = null;

  @JsonProperty("ext1")
  private String ext1 = null;

  @JsonProperty("ext2")
  private String ext2 = null;

  @JsonProperty("objStatus")
  private Integer objStatus = null;

  @JsonProperty("groupId")
  private Long groupId = null;

  @JsonProperty("pageNo")
  private Integer pageNo = null;

  @JsonProperty("pageSize")
  private Integer pageSize = null;
  @JsonProperty("objFlag")
  private Integer objFlag = null;

  @JsonIgnore
  public MsMataDataQueryRequest objId(Long objId) {
    this.objId = objId;
    return this;
  }

   /**
   * null
   * @return objId
  **/
  @ApiModelProperty(value = "null")
  public Long getObjId() {
    return objId;
  }

  public void setObjId(Long objId) {
    this.objId = objId;
  }

  @JsonIgnore
  public MsMataDataQueryRequest objCode(String objCode) {
    this.objCode = objCode;
    return this;
  }

   /**
   * null
   * @return objCode
  **/
  @ApiModelProperty(value = "null")
  public String getObjCode() {
    return objCode;
  }

  public void setObjCode(String objCode) {
    this.objCode = objCode;
  }

  @JsonIgnore
  public MsMataDataQueryRequest objName(String objName) {
    this.objName = objName;
    return this;
  }

   /**
   * null
   * @return objName
  **/
  @ApiModelProperty(value = "null")
  public String getObjName() {
    return objName;
  }

  public void setObjName(String objName) {
    this.objName = objName;
  }

  @JsonIgnore
  public MsMataDataQueryRequest objType(String objType) {
    this.objType = objType;
    return this;
  }

  public Integer getObjFlag() {
    return objFlag;
  }

  public void setObjFlag(Integer objFlag) {
    this.objFlag = objFlag;
  }

  /**
   * 房地产 酒店等业务类型 为中文描述
   * @return objType
  **/
  @ApiModelProperty(value = "房地产 酒店等业务类型 为中文描述")
  public String getObjType() {
    return objType;
  }

  public void setObjType(String objType) {
    this.objType = objType;
  }

  @JsonIgnore
  public MsMataDataQueryRequest ext1(String ext1) {
    this.ext1 = ext1;
    return this;
  }

   /**
   * 扩展字段1 拆票规则中 发票类型,票面信息规则 表示 销方创建AR 购方创建AP
   * @return ext1
  **/
  @ApiModelProperty(value = "扩展字段1 拆票规则中 发票类型,票面信息规则 表示 销方创建AR 购方创建AP")
  public String getExt1() {
    return ext1;
  }

  public void setExt1(String ext1) {
    this.ext1 = ext1;
  }

  @JsonIgnore
  public MsMataDataQueryRequest ext2(String ext2) {
    this.ext2 = ext2;
    return this;
  }

   /**
   * 扩展字段2
   * @return ext2
  **/
  @ApiModelProperty(value = "扩展字段2")
  public String getExt2() {
    return ext2;
  }

  public void setExt2(String ext2) {
    this.ext2 = ext2;
  }

  @JsonIgnore
  public MsMataDataQueryRequest objStatus(Integer objStatus) {
    this.objStatus = objStatus;
    return this;
  }

   /**
   * 状态码
   * @return objStatus
  **/
  @ApiModelProperty(value = "状态码")
  public Integer getObjStatus() {
    return objStatus;
  }

  public void setObjStatus(Integer objStatus) {
    this.objStatus = objStatus;
  }

  @JsonIgnore
  public MsMataDataQueryRequest groupId(Long groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 公司ID
   * @return groupId
  **/
  @ApiModelProperty(value = "公司ID")
  public Long getGroupId() {
    return groupId;
  }

  public void setGroupId(Long groupId) {
    this.groupId = groupId;
  }

  @JsonIgnore
  public MsMataDataQueryRequest pageNo(Integer pageNo) {
    this.pageNo = pageNo;
    return this;
  }

   /**
   * 当前页数
   * @return pageNo
  **/
  @ApiModelProperty(value = "当前页数")
  public Integer getPageNo() {
    return pageNo;
  }

  public void setPageNo(Integer pageNo) {
    this.pageNo = pageNo;
  }

  @JsonIgnore
  public MsMataDataQueryRequest pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * 每页数量
   * @return pageSize
  **/
  @ApiModelProperty(value = "每页数量")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsMataDataQueryRequest mataDataQueryRequest = (MsMataDataQueryRequest) o;
    return Objects.equals(this.objId, mataDataQueryRequest.objId) &&
        Objects.equals(this.objCode, mataDataQueryRequest.objCode) &&
        Objects.equals(this.objName, mataDataQueryRequest.objName) &&
        Objects.equals(this.objType, mataDataQueryRequest.objType) &&
        Objects.equals(this.ext1, mataDataQueryRequest.ext1) &&
        Objects.equals(this.ext2, mataDataQueryRequest.ext2) &&
        Objects.equals(this.objStatus, mataDataQueryRequest.objStatus) &&
        Objects.equals(this.groupId, mataDataQueryRequest.groupId) &&
        Objects.equals(this.pageNo, mataDataQueryRequest.pageNo) &&
        Objects.equals(this.pageSize, mataDataQueryRequest.pageSize);
  }

  @Override
  public int hashCode() {
    return Objects.hash(objId, objCode, objName, objType, ext1, ext2, objStatus, groupId, pageNo, pageSize);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsMataDataQueryRequest {\n");
    
    sb.append("    objId: ").append(toIndentedString(objId)).append("\n");
    sb.append("    objCode: ").append(toIndentedString(objCode)).append("\n");
    sb.append("    objName: ").append(toIndentedString(objName)).append("\n");
    sb.append("    objType: ").append(toIndentedString(objType)).append("\n");
    sb.append("    ext1: ").append(toIndentedString(ext1)).append("\n");
    sb.append("    ext2: ").append(toIndentedString(ext2)).append("\n");
    sb.append("    objStatus: ").append(toIndentedString(objStatus)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    pageNo: ").append(toIndentedString(pageNo)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
