package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.seller.config.client.model.MsBusinessObjBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 元数据对象分页结果
 */
@ApiModel(description = "元数据对象分页结果")

@JsonInclude(NON_NULL)
public class MsMetaDataPageDTO {
  @JsonProperty("total")
  private Integer total = null;

  @JsonProperty("pageNo")
  private Integer pageNo = null;

  @JsonProperty("result")
  private List<MsBusinessObjBean> result = new ArrayList<MsBusinessObjBean>();

  @JsonIgnore
  public MsMetaDataPageDTO total(Integer total) {
    this.total = total;
    return this;
  }

   /**
   * 发起 1表示已受理 -1表示调用失败 查询 1表示处理完成 2表示处理中
   * @return total
  **/
  @ApiModelProperty(value = "发起 1表示已受理 -1表示调用失败 查询 1表示处理完成 2表示处理中")
  public Integer getTotal() {
    return total;
  }

  public void setTotal(Integer total) {
    this.total = total;
  }

  @JsonIgnore
  public MsMetaDataPageDTO pageNo(Integer pageNo) {
    this.pageNo = pageNo;
    return this;
  }

   /**
   * return message
   * @return pageNo
  **/
  @ApiModelProperty(value = "return message")
  public Integer getPageNo() {
    return pageNo;
  }

  public void setPageNo(Integer pageNo) {
    this.pageNo = pageNo;
  }

  @JsonIgnore
  public MsMetaDataPageDTO result(List<MsBusinessObjBean> result) {
    this.result = result;
    return this;
  }

  public MsMetaDataPageDTO addResultItem(MsBusinessObjBean resultItem) {
    this.result.add(resultItem);
    return this;
  }

   /**
   * 返回对象,根据不同调用方法,返回的属性不一样
   * @return result
  **/
  @ApiModelProperty(value = "返回对象,根据不同调用方法,返回的属性不一样")
  public List<MsBusinessObjBean> getResult() {
    return result;
  }

  public void setResult(List<MsBusinessObjBean> result) {
    this.result = result;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsMetaDataPageDTO metaDataPageDTO = (MsMetaDataPageDTO) o;
    return Objects.equals(this.total, metaDataPageDTO.total) &&
        Objects.equals(this.pageNo, metaDataPageDTO.pageNo) &&
        Objects.equals(this.result, metaDataPageDTO.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(total, pageNo, result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsMetaDataPageDTO {\n");
    
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    pageNo: ").append(toIndentedString(pageNo)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
