package com.xforceplus.seller.config.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * null
 */
@ApiModel(description = "null")

@JsonInclude(NON_NULL)
public class MsMetadataItemQueryRequest {
  /**
   * 业务id
   */
  @JsonProperty("businessObjId")
  private Long businessObjId = null;
  /**
   * 对象编码
   */
  @JsonProperty("objCode")
  private String objCode;

  /**
   * 业务类型
   */
  @JsonProperty("salesbillType")
  private String salesbillType;

  @ApiModelProperty(value = "业务类型")
  public String getSalesbillType() {
    return salesbillType;
  }

  public void setSalesbillType(String salesbillType) {
    this.salesbillType = salesbillType;
  }

  /**
   * 对象编码
   * @return businessObjId
   **/
  @ApiModelProperty(value = "对象编码")
  public String getObjCode() {
    return objCode;
  }

  public void setObjCode(String objCode) {
    this.objCode = objCode;
  }

  @JsonIgnore
  public MsMetadataItemQueryRequest businessObjId(Long businessObjId) {
    this.businessObjId = businessObjId;
    return this;
  }

   /**
   * 业务对象主键
   * @return businessObjId
  **/
  @ApiModelProperty(value = "业务对象主键")
  public Long getBusinessObjId() {
    return businessObjId;
  }

  public void setBusinessObjId(Long businessObjId) {
    this.businessObjId = businessObjId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsMetadataItemQueryRequest metadataItemQueryRequest = (MsMetadataItemQueryRequest) o;
    return Objects.equals(this.businessObjId, metadataItemQueryRequest.businessObjId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(businessObjId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsMetadataItemQueryRequest {\n");
    
    sb.append("    businessObjId: ").append(toIndentedString(businessObjId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
