package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsQueryAllTaxDeviceByTaxDeviceTypesRequest
 */

@JsonInclude(NON_NULL)
public class MsQueryAllTaxDeviceByTaxDeviceTypesRequest {
  @JsonProperty("taxDeviceTypes")
  private List<Integer> taxDeviceTypes = new ArrayList<Integer>();

  @JsonIgnore
  public MsQueryAllTaxDeviceByTaxDeviceTypesRequest taxDeviceTypes(List<Integer> taxDeviceTypes) {
    this.taxDeviceTypes = taxDeviceTypes;
    return this;
  }

  public MsQueryAllTaxDeviceByTaxDeviceTypesRequest addTaxDeviceTypesItem(Integer taxDeviceTypesItem) {
    this.taxDeviceTypes.add(taxDeviceTypesItem);
    return this;
  }

   /**
   * Get taxDeviceTypes
   * @return taxDeviceTypes
  **/
  @ApiModelProperty(value = "")
  public List<Integer> getTaxDeviceTypes() {
    return taxDeviceTypes;
  }

  public void setTaxDeviceTypes(List<Integer> taxDeviceTypes) {
    this.taxDeviceTypes = taxDeviceTypes;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsQueryAllTaxDeviceByTaxDeviceTypesRequest queryAllTaxDeviceByTaxDeviceTypesRequest = (MsQueryAllTaxDeviceByTaxDeviceTypesRequest) o;
    return Objects.equals(this.taxDeviceTypes, queryAllTaxDeviceByTaxDeviceTypesRequest.taxDeviceTypes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(taxDeviceTypes);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsQueryAllTaxDeviceByTaxDeviceTypesRequest {\n");
    
    sb.append("    taxDeviceTypes: ").append(toIndentedString(taxDeviceTypes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
