package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 标准请求头
 */
@ApiModel(description = "标准请求头")

@JsonInclude(NON_NULL)
public class MsRequestHead {
  @JsonProperty("tenantId")
  private String tenantId = null;

  @JsonProperty("debug")
  private String debug = null;

  @JsonIgnore
  public MsRequestHead tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户ID
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户ID")
  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsRequestHead debug(String debug) {
    this.debug = debug;
    return this;
  }

   /**
   * 调试信息(仅供调试使用)
   * @return debug
  **/
  @ApiModelProperty(value = "调试信息(仅供调试使用)")
  public String getDebug() {
    return debug;
  }

  public void setDebug(String debug) {
    this.debug = debug;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsRequestHead requestHead = (MsRequestHead) o;
    return Objects.equals(this.tenantId, requestHead.tenantId) &&
        Objects.equals(this.debug, requestHead.debug);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tenantId, debug);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsRequestHead {\n");
    
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    debug: ").append(toIndentedString(debug)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
