package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 发起请求返回结果
 */
@ApiModel(description = "发起请求返回结果")

@JsonInclude(NON_NULL)
public class MsResponse <T> {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @ApiModelProperty(value = "return message")
  @JsonProperty("traceId")
  private String traceId = "";

  @JsonProperty("result")
  private T result = null;
  @JsonProperty("salesbillType")
  private String salesbillType;

  /**
   * 为了解决稀巴烂的无法扩展的 API 设计, 只能在这里扩展 Response了, 这TM是敬业态度问题
   * 不懂优秀 API 设计的可以读读谷朴的文章
   * {@link # https://yq.aliyun.com/articles/683044 }
   */

  @JsonIgnore
  public MsResponse code(Integer code) {
    this.code = code;
    return this;
  }

  @JsonIgnore
  public MsResponse traceId(String traceId) {
    this.traceId = traceId;
    return this;
  }

   /**
   * 发起 1表示已受理 -1表示调用失败 查询 1表示处理完成 2表示处理中
   * @return code
  **/
  @ApiModelProperty(value = "发起 1表示已受理 -1表示调用失败 查询 1表示处理完成 2表示处理中")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsResponse message(String message) {
    this.message = message;
    return this;
  }
  public static MsResponse error(String message){
    MsResponse msResponse=new MsResponse();
    msResponse.setCode(Response.Fail);
    msResponse.setMessage(message);
    return msResponse;
  }

  public static MsResponse ok(Object o){
    MsResponse msResponse=new MsResponse();
    msResponse.setCode(Response.OK);
    msResponse.setResult(o);
    msResponse.setMessage("成功");
    return msResponse;
  }
   /**
   * return message
   * @return message
  **/
  @ApiModelProperty(value = "return message")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsResponse result(T result) {
    this.result = result;
    return this;
  }

   /**
   * 返回对象,根据不同调用方法,返回的属性不一样
   * @return result
  **/
  @ApiModelProperty(value = "返回对象,根据不同调用方法,返回的属性不一样")
  public T getResult() {
    return result;
  }

  public void setResult(T result) {
    this.result = result;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsResponse response = (MsResponse) o;
    return Objects.equals(this.code, response.code) &&
        Objects.equals(this.message, response.message) &&
        Objects.equals(this.result, response.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, result);
  }

  public String getTraceId() {
    return traceId;
  }

  public void setTraceId(String traceId) {
    this.traceId = traceId;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  public String getSalesbillType() {
    return salesbillType;
  }

  public void setSalesbillType(String salesbillType) {
    this.salesbillType = salesbillType;
  }
}
