package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 设备信息
 */
@ApiModel(description = "设备信息")

@JsonInclude(NON_NULL)
public class MsTaxDeviceInfo {
  @JsonProperty("invoiceType")
  private List<String> invoiceType = new ArrayList<String>();

  @JsonProperty("taxDeviceType")
  private Integer taxDeviceType = null;

  @JsonProperty("deployType")
  private Integer deployType = null;

  @JsonProperty("taxDeviceMachineNo")
  private String taxDeviceMachineNo = null;

  @JsonProperty("taxDevicePassword")
  private String taxDevicePassword = null;

  @JsonProperty("taxDeviceDigitalPassword")
  private String taxDeviceDigitalPassword = null;

  @JsonProperty("photos")
  private List<String> photos = new ArrayList<String>();

  @JsonProperty("ip")
  private String ip = null;

  @JsonProperty("port")
  private Integer port = null;

  @JsonProperty("nationalTaxPassword")
  private String nationalTaxPassword = null;

  @JsonProperty("terminalId")
  private Long terminalId = null;

  @JsonProperty("elConfirmPassword")
  private String elConfirmPassword;

  @JsonIgnore
  public MsTaxDeviceInfo invoiceType(List<String> invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

  public MsTaxDeviceInfo addInvoiceTypeItem(String invoiceTypeItem) {
    this.invoiceType.add(invoiceTypeItem);
    return this;
  }

   /**
   * 发票类型（s:增值税专票，c:增值税普票，ce:电子发票，ju:增值税卷票，v:机动车发票，v2:二手机动车发票）
   * @return invoiceType
  **/
  @ApiModelProperty(value = "发票类型（s:增值税专票，c:增值税普票，ce:电子发票，ju:增值税卷票，v:机动车发票，v2:二手机动车发票）")
  public List<String> getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(List<String> invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public MsTaxDeviceInfo taxDeviceType(Integer taxDeviceType) {
    this.taxDeviceType = taxDeviceType;
    return this;
  }

   /**
   * 1 百望单盘 2 百望服务器  3 航信单盘 4 航信服务器
   * @return taxDeviceType
  **/
  @ApiModelProperty(value = "1 百望单盘 2 百望服务器  3 航信单盘 4 航信服务器")
  public Integer getTaxDeviceType() {
    return taxDeviceType;
  }

  public void setTaxDeviceType(Integer taxDeviceType) {
    this.taxDeviceType = taxDeviceType;
  }

  @JsonIgnore
  public MsTaxDeviceInfo deployType(Integer deployType) {
    this.deployType = deployType;
    return this;
  }

   /**
   * 部署类型，1:票易通自建 2：托管 3：陈列
   * @return deployType
  **/
  @ApiModelProperty(value = "部署类型，1:票易通自建 2：托管 3：陈列")
  public Integer getDeployType() {
    return deployType;
  }

  public void setDeployType(Integer deployType) {
    this.deployType = deployType;
  }

  @JsonIgnore
  public MsTaxDeviceInfo taxDeviceMachineNo(String taxDeviceMachineNo) {
    this.taxDeviceMachineNo = taxDeviceMachineNo;
    return this;
  }

   /**
   * 开票机号
   * @return taxDeviceMachineNo
  **/
  @ApiModelProperty(value = "开票机号")
  public String getTaxDeviceMachineNo() {
    return taxDeviceMachineNo;
  }

  public void setTaxDeviceMachineNo(String taxDeviceMachineNo) {
    this.taxDeviceMachineNo = taxDeviceMachineNo;
  }

  @JsonIgnore
  public MsTaxDeviceInfo taxDevicePassword(String taxDevicePassword) {
    this.taxDevicePassword = taxDevicePassword;
    return this;
  }

   /**
   * 税控盘密码
   * @return taxDevicePassword
  **/
  @ApiModelProperty(value = "税控盘密码")
  public String getTaxDevicePassword() {
    return taxDevicePassword;
  }

  public void setTaxDevicePassword(String taxDevicePassword) {
    this.taxDevicePassword = taxDevicePassword;
  }

  @JsonIgnore
  public MsTaxDeviceInfo taxDeviceDigitalPassword(String taxDeviceDigitalPassword) {
    this.taxDeviceDigitalPassword = taxDeviceDigitalPassword;
    return this;
  }

   /**
   * 税务数字证书密码
   * @return taxDeviceDigitalPassword
  **/
  @ApiModelProperty(value = "税务数字证书密码")
  public String getTaxDeviceDigitalPassword() {
    return taxDeviceDigitalPassword;
  }

  public void setTaxDeviceDigitalPassword(String taxDeviceDigitalPassword) {
    this.taxDeviceDigitalPassword = taxDeviceDigitalPassword;
  }

  @JsonIgnore
  public MsTaxDeviceInfo photos(List<String> photos) {
    this.photos = photos;
    return this;
  }

  public MsTaxDeviceInfo addPhotosItem(String photosItem) {
    this.photos.add(photosItem);
    return this;
  }

   /**
   * 图片
   * @return photos
  **/
  @ApiModelProperty(value = "图片")
  public List<String> getPhotos() {
    return photos;
  }

  public void setPhotos(List<String> photos) {
    this.photos = photos;
  }

  @JsonIgnore
  public MsTaxDeviceInfo ip(String ip) {
    this.ip = ip;
    return this;
  }

   /**
   * ip:服务器模式时输入
   * @return ip
  **/
  @ApiModelProperty(value = "ip:服务器模式时输入")
  public String getIp() {
    return ip;
  }

  public void setIp(String ip) {
    this.ip = ip;
  }

  @JsonIgnore
  public MsTaxDeviceInfo port(Integer port) {
    this.port = port;
    return this;
  }

   /**
   * 端口：服务器模式时输入
   * @return port
  **/
  @ApiModelProperty(value = "端口：服务器模式时输入")
  public Integer getPort() {
    return port;
  }

  public void setPort(Integer port) {
    this.port = port;
  }

  @JsonIgnore
  public MsTaxDeviceInfo nationalTaxPassword(String nationalTaxPassword) {
    this.nationalTaxPassword = nationalTaxPassword;
    return this;
  }

   /**
   * 国税自定义密码
   * @return nationalTaxPassword
  **/
  @ApiModelProperty(value = "国税自定义密码")
  public String getNationalTaxPassword() {
    return nationalTaxPassword;
  }

  public void setNationalTaxPassword(String nationalTaxPassword) {
    this.nationalTaxPassword = nationalTaxPassword;
  }

  @JsonIgnore
  public MsTaxDeviceInfo terminalId(Long terminalId) {
    this.terminalId = terminalId;
    return this;
  }

   /**
   * 终端id，服务器模式税控钥匙/UKey时填入
   * @return terminalId
  **/
  @ApiModelProperty(value = "终端id，服务器模式税控钥匙/UKey时填入")
  public Long getTerminalId() {
    return terminalId;
  }

  public void setTerminalId(Long terminalId) {
    this.terminalId = terminalId;
  }


  @JsonIgnore
  public MsTaxDeviceInfo elConfirmPassword(String elConfirmPassword) {
    this.elConfirmPassword = elConfirmPassword;
    return this;
  }

  @ApiModelProperty(value = "抵扣统计确认密码")
  public String getElConfirmPassword() {
    return elConfirmPassword;
  }

  public void setElConfirmPassword(String elConfirmPassword) {
    this.elConfirmPassword = elConfirmPassword;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTaxDeviceInfo taxDeviceInfo = (MsTaxDeviceInfo) o;
    return Objects.equals(this.invoiceType, taxDeviceInfo.invoiceType) &&
        Objects.equals(this.taxDeviceType, taxDeviceInfo.taxDeviceType) &&
        Objects.equals(this.deployType, taxDeviceInfo.deployType) &&
        Objects.equals(this.taxDeviceMachineNo, taxDeviceInfo.taxDeviceMachineNo) &&
        Objects.equals(this.taxDevicePassword, taxDeviceInfo.taxDevicePassword) &&
        Objects.equals(this.taxDeviceDigitalPassword, taxDeviceInfo.taxDeviceDigitalPassword) &&
        Objects.equals(this.photos, taxDeviceInfo.photos) &&
        Objects.equals(this.ip, taxDeviceInfo.ip) &&
        Objects.equals(this.port, taxDeviceInfo.port) &&
        Objects.equals(this.nationalTaxPassword, taxDeviceInfo.nationalTaxPassword) &&
        Objects.equals(this.terminalId, taxDeviceInfo.terminalId)&&
        Objects.equals(this.elConfirmPassword, taxDeviceInfo.elConfirmPassword);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceType, taxDeviceType, deployType, taxDeviceMachineNo, taxDevicePassword, taxDeviceDigitalPassword, photos, ip, port, nationalTaxPassword, terminalId, elConfirmPassword);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTaxDeviceInfo {\n");
    
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    taxDeviceType: ").append(toIndentedString(taxDeviceType)).append("\n");
    sb.append("    deployType: ").append(toIndentedString(deployType)).append("\n");
    sb.append("    taxDeviceMachineNo: ").append(toIndentedString(taxDeviceMachineNo)).append("\n");
    sb.append("    taxDevicePassword: ").append(toIndentedString(taxDevicePassword)).append("\n");
    sb.append("    taxDeviceDigitalPassword: ").append(toIndentedString(taxDeviceDigitalPassword)).append("\n");
    sb.append("    photos: ").append(toIndentedString(photos)).append("\n");
    sb.append("    ip: ").append(toIndentedString(ip)).append("\n");
    sb.append("    port: ").append(toIndentedString(port)).append("\n");
    sb.append("    nationalTaxPassword: ").append(toIndentedString(nationalTaxPassword)).append("\n");
    sb.append("    terminalId: ").append(toIndentedString(terminalId)).append("\n");
    sb.append("    elConfirmPassword: ").append(toIndentedString(elConfirmPassword)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
