package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.seller.config.client.model.MsTerminalQueryResponseInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 查询开票终端结果
 */
@ApiModel(description = "查询开票终端结果")

@JsonInclude(NON_NULL)
public class MsTerminalQueryMakeOutResult {
  @JsonProperty("makeOutTerminals")
  private List<MsTerminalQueryResponseInfo> makeOutTerminals = new ArrayList<MsTerminalQueryResponseInfo>();

  @JsonProperty("printTerminals")
  private List<MsTerminalQueryResponseInfo> printTerminals = new ArrayList<MsTerminalQueryResponseInfo>();

  @JsonIgnore
  public MsTerminalQueryMakeOutResult makeOutTerminals(List<MsTerminalQueryResponseInfo> makeOutTerminals) {
    this.makeOutTerminals = makeOutTerminals;
    return this;
  }

  public MsTerminalQueryMakeOutResult addMakeOutTerminalsItem(MsTerminalQueryResponseInfo makeOutTerminalsItem) {
    this.makeOutTerminals.add(makeOutTerminalsItem);
    return this;
  }

   /**
   * 开具终端信息
   * @return makeOutTerminals
  **/
  @ApiModelProperty(value = "开具终端信息")
  public List<MsTerminalQueryResponseInfo> getMakeOutTerminals() {
    return makeOutTerminals;
  }

  public void setMakeOutTerminals(List<MsTerminalQueryResponseInfo> makeOutTerminals) {
    this.makeOutTerminals = makeOutTerminals;
  }

  @JsonIgnore
  public MsTerminalQueryMakeOutResult printTerminals(List<MsTerminalQueryResponseInfo> printTerminals) {
    this.printTerminals = printTerminals;
    return this;
  }

  public MsTerminalQueryMakeOutResult addPrintTerminalsItem(MsTerminalQueryResponseInfo printTerminalsItem) {
    this.printTerminals.add(printTerminalsItem);
    return this;
  }

   /**
   * 打印终端信息
   * @return printTerminals
  **/
  @ApiModelProperty(value = "打印终端信息")
  public List<MsTerminalQueryResponseInfo> getPrintTerminals() {
    return printTerminals;
  }

  public void setPrintTerminals(List<MsTerminalQueryResponseInfo> printTerminals) {
    this.printTerminals = printTerminals;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTerminalQueryMakeOutResult terminalQueryMakeOutResult = (MsTerminalQueryMakeOutResult) o;
    return Objects.equals(this.makeOutTerminals, terminalQueryMakeOutResult.makeOutTerminals) &&
        Objects.equals(this.printTerminals, terminalQueryMakeOutResult.printTerminals);
  }

  @Override
  public int hashCode() {
    return Objects.hash(makeOutTerminals, printTerminals);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTerminalQueryMakeOutResult {\n");
    
    sb.append("    makeOutTerminals: ").append(toIndentedString(makeOutTerminals)).append("\n");
    sb.append("    printTerminals: ").append(toIndentedString(printTerminals)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
