package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.seller.config.client.model.MsConfigItemTempBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonInclude(NON_NULL)
public class MsTmpConfigAddRequest {
  @JsonProperty("entityList")
  private List<MsConfigItemTempBean> entityList = new ArrayList<MsConfigItemTempBean>();

  @JsonProperty("userId")
  private Long userId = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("configType")
  private Integer configType = null;

  @JsonProperty("businessBillType")
  private String businessBillType;

  @JsonIgnore
  public MsTmpConfigAddRequest entityList(List<MsConfigItemTempBean> entityList) {
    this.entityList = entityList;
    return this;
  }

  public MsTmpConfigAddRequest addEntityListItem(MsConfigItemTempBean entityListItem) {
    this.entityList.add(entityListItem);
    return this;
  }

   /**
   * null
   * @return entityList
  **/
  @ApiModelProperty(value = "null")
  public List<MsConfigItemTempBean> getEntityList() {
    return entityList;
  }

  public void setEntityList(List<MsConfigItemTempBean> entityList) {
    this.entityList = entityList;
  }

  @JsonIgnore
  public MsTmpConfigAddRequest userId(Long userId) {
    this.userId = userId;
    return this;
  }

   /**
   * 用户Id
   * @return userId
  **/
  @ApiModelProperty(value = "用户Id")
  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }

  @JsonIgnore
  public MsTmpConfigAddRequest invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型
   * @return invoiceType
  **/
  @ApiModelProperty(value = "发票类型")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public MsTmpConfigAddRequest sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

   /**
   * 销方税号
   * @return sellerTaxNo
  **/
  @ApiModelProperty(value = "销方税号")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @JsonIgnore
  public MsTmpConfigAddRequest configType(Integer configType) {
    this.configType = configType;
    return this;
  }
  @ApiModelProperty(value = "业务单类型")
  public String getBusinessBillType() {
    return businessBillType;
  }

  public void setBusinessBillType(String businessBillType) {
    this.businessBillType = businessBillType;
  }

  /**
   * 配置类型
   * @return configType
  **/
  @ApiModelProperty(value = "配置类型")
  public Integer getConfigType() {
    return configType;
  }

  public void setConfigType(Integer configType) {
    this.configType = configType;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTmpConfigAddRequest tmpConfigAddRequest = (MsTmpConfigAddRequest) o;
    return Objects.equals(this.entityList, tmpConfigAddRequest.entityList) &&
        Objects.equals(this.userId, tmpConfigAddRequest.userId) &&
        Objects.equals(this.invoiceType, tmpConfigAddRequest.invoiceType) &&
        Objects.equals(this.sellerTaxNo, tmpConfigAddRequest.sellerTaxNo) &&
        Objects.equals(this.configType, tmpConfigAddRequest.configType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(entityList, userId, invoiceType, sellerTaxNo, configType);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTmpConfigAddRequest {\n");
    
    sb.append("    entityList: ").append(toIndentedString(entityList)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
    sb.append("    configType: ").append(toIndentedString(configType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
