package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.seller.config.client.model.MsResponseHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsUpdateTerminalResponse
 */

@JsonInclude(NON_NULL)
public class MsUpdateTerminalResponse {
  @JsonProperty("head")
  private MsResponseHead head = null;

  @JsonIgnore
  public MsUpdateTerminalResponse head(MsResponseHead head) {
    this.head = head;
    return this;
  }

   /**
   * 终端更新
   * @return head
  **/
  @ApiModelProperty(value = "终端更新")
  public MsResponseHead getHead() {
    return head;
  }

  public void setHead(MsResponseHead head) {
    this.head = head;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsUpdateTerminalResponse updateTerminalResponse = (MsUpdateTerminalResponse) o;
    return Objects.equals(this.head, updateTerminalResponse.head);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsUpdateTerminalResponse {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
