package com.xforceplus.seller.config.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 项目名称:
 * 模块名称:
 * 说明:
 * JDK 版本:      1.8
 * 作者(@author): chen cheng
 * 创建日期:      2019/4/3 20:50
 */
@ApiModel(description = "查询自定义查询条件请求")

@JsonInclude(NON_NULL)
public class QueryCustomFiltersRequest {

    @JsonProperty("userInfo")
    @ApiModelProperty(value = "功能点名称")
    private UserInfo userInfo;

    @JsonProperty("functionPoint")
    @ApiModelProperty(value = "功能点名称")
    private String functionPoint;

    @JsonProperty("subPointList")
    @ApiModelProperty(value = "字段名称")
    private List<String> subPointList;


    public String getFunctionPoint() {
        return functionPoint;
    }

    public void setFunctionPoint(String functionPoint) {
        this.functionPoint = functionPoint;
    }

    public List<String> getSubPointList() {
        return subPointList;
    }

    public void setSubPointList(List<String> subPointList) {
        this.subPointList = subPointList;
    }

    public UserInfo getUserInfo() {
        return userInfo;
    }

    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }
}
