package com.xforceplus.seller.config.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * general nationalEntity object
 */
@ApiModel(description = "general nationalEntity object")

@JsonInclude(NON_NULL)
public class TaxNationalCode {
  @JsonProperty("goodsTaxNo")
  private String goodsTaxNo = null;

  @JsonProperty("taxcodeName")
  private String taxcodeName = null;

  @JsonProperty("taxcodeShortName")
  private String taxcodeShortName = null;

  @JsonProperty("explainDes")
  private String explainDes = null;

  @JsonProperty("version")
  private String version = null;

  @JsonProperty("splitCode")
  private String splitCode = null;

  @JsonProperty("itemTypeCode")
  private String itemTypeCode = null;

  @JsonProperty("endFlag")
  private Integer endFlag = null;



  /**
   * 税率
   */
  @JsonProperty("taxRate")
  private List<String> taxRate;

  private List<taxRateItem> preferentialTaxList;

  @Data
 public static class taxRateItem{
    /**
     * 是否享受税收优惠政策0-不1-享受
     * 表 : ord_salesbill_item
     * 对应字段 : tax_pre
     */
    @JsonProperty("taxPre")
    private String taxPre;

    @JsonProperty("taxPreCon")
    private String taxPreCon;
    /**
     * 零税率标志空-非0税率；0-出口退税1-免税2-不征税3-普通0税率
     * 零税率标识： 1 免税 ；2 不征税 ；3 普通0税率 ；0 出口退税
     * 表 : ord_salesbill_item
     * 对应字段 : zero_tax
     */
    @JsonProperty("zeroTax")
    private String zeroTax;

    @JsonProperty("taxRate")
    private String taxRate;
  }


  public List<taxRateItem> getPreferentialTaxList() {
    return preferentialTaxList;
  }

  public void setPreferentialTaxList(List<taxRateItem> preferentialTaxList) {
    this.preferentialTaxList = preferentialTaxList;
  }

  public List<String> getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(List<String> taxRate) {
    this.taxRate = taxRate;
  }



  /**
   * 末级标志 0没有达到末级 1达到末级
   * @return
   */
  public Integer getEndFlag() {
    return endFlag;
  }

  public void setEndFlag(Integer endFlag) {
    this.endFlag = endFlag;
  }

  @JsonIgnore
  public TaxNationalCode goodsTaxNo(String goodsTaxNo) {
    this.goodsTaxNo = goodsTaxNo;
    return this;
  }

   /**
   * 税收分类编码
   * @return goodsTaxNo
  **/
  @ApiModelProperty(value = "税收分类编码")
  public String getGoodsTaxNo() {
    return goodsTaxNo;
  }

  public void setGoodsTaxNo(String goodsTaxNo) {
    this.goodsTaxNo = goodsTaxNo;
  }

  @JsonIgnore
  public TaxNationalCode taxcodeName(String taxcodeName) {
    this.taxcodeName = taxcodeName;
    return this;
  }

   /**
   * 税编名称
   * @return taxcodeName
  **/
  @ApiModelProperty(value = "税编名称")
  public String getTaxcodeName() {
    return taxcodeName;
  }

  public void setTaxcodeName(String taxcodeName) {
    this.taxcodeName = taxcodeName;
  }

  @JsonIgnore
  public TaxNationalCode taxcodeShortName(String taxcodeShortName) {
    this.taxcodeShortName = taxcodeShortName;
    return this;
  }

   /**
   * 税编简称
   * @return taxcodeShortName
  **/
  @ApiModelProperty(value = "税编简称")
  public String getTaxcodeShortName() {
    return taxcodeShortName;
  }

  public void setTaxcodeShortName(String taxcodeShortName) {
    this.taxcodeShortName = taxcodeShortName;
  }

  @JsonIgnore
  public TaxNationalCode explainDes(String explainDes) {
    this.explainDes = explainDes;
    return this;
  }

   /**
   * 说明
   * @return explainDes
  **/
  @ApiModelProperty(value = "说明")
  public String getExplainDes() {
    return explainDes;
  }

  public void setExplainDes(String explainDes) {
    this.explainDes = explainDes;
  }

  @JsonIgnore
  public TaxNationalCode version(String version) {
    this.version = version;
    return this;
  }

   /**
   * 版本
   * @return version
  **/
  @ApiModelProperty(value = "版本")
  public String getVersion() {
    return version;
  }

  public void setVersion(String version) {
    this.version = version;
  }

  @JsonIgnore
  public TaxNationalCode splitCode(String splitCode) {
    this.splitCode = splitCode;
    return this;
  }

   /**
   * 是否可以混开
   * @return splitCode
  **/
  @ApiModelProperty(value = "是否可以混开")
  public String getSplitCode() {
    return splitCode;
  }

  public void setSplitCode(String splitCode) {
    this.splitCode = splitCode;
  }

  @JsonIgnore
  public TaxNationalCode itemTypeCode(String itemTypeCode) {
    this.itemTypeCode = itemTypeCode;
    return this;
  }

   /**
   * 分类码
   * @return itemTypeCode
  **/
  @ApiModelProperty(value = "分类码")
  public String getItemTypeCode() {
    return itemTypeCode;
  }

  public void setItemTypeCode(String itemTypeCode) {
    this.itemTypeCode = itemTypeCode;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TaxNationalCode taxNationalCode = (TaxNationalCode) o;
    return Objects.equals(this.goodsTaxNo, taxNationalCode.goodsTaxNo) &&
        Objects.equals(this.taxcodeName, taxNationalCode.taxcodeName) &&
        Objects.equals(this.taxcodeShortName, taxNationalCode.taxcodeShortName) &&
        Objects.equals(this.explainDes, taxNationalCode.explainDes) &&
        Objects.equals(this.version, taxNationalCode.version) &&
        Objects.equals(this.splitCode, taxNationalCode.splitCode) &&
        Objects.equals(this.itemTypeCode, taxNationalCode.itemTypeCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(goodsTaxNo, taxcodeName, taxcodeShortName, explainDes, version, splitCode, itemTypeCode);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TaxNationalCode {\n");

    sb.append("    goodsTaxNo: ").append(toIndentedString(goodsTaxNo)).append("\n");
    sb.append("    taxcodeName: ").append(toIndentedString(taxcodeName)).append("\n");
    sb.append("    taxcodeShortName: ").append(toIndentedString(taxcodeShortName)).append("\n");
    sb.append("    explainDes: ").append(toIndentedString(explainDes)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    splitCode: ").append(toIndentedString(splitCode)).append("\n");
    sb.append("    itemTypeCode: ").append(toIndentedString(itemTypeCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
