package com.xforceplus.seller.config.client.parse.bean;
import com.xforceplus.seller.config.client.parse.BaseRuleBean;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 项目名称: 票易通
 * 模块名称: 发票匹配单据规则DTO 返回给其他应用或微服务
 * JDK 版本: JDK1.8
 * 说明:
 * 作者(@author): wangjingshuang
 * 创建时间: 2020年2月13日17:07:17
 */
public class InvoiceMatchBillConfigDTO extends BaseRuleBean {

    @ApiModelProperty("自动匹配开关")
    private Boolean autoInvoiceMatchSwitch;

    @ApiModelProperty("自动匹配条件")
    private List<String> autoInvoiceMatchCondition  = new ArrayList<>();

    @ApiModelProperty("匹配容差")
    private BigDecimal allowanceNum;

    @ApiModelProperty("匹配可选字段")
    private List<String> invoiceMatchOptionalFieldList  = new ArrayList<>();

    @ApiModelProperty("匹配标准字段")
    private List<String> invoiceMatchStandardFieldList  = new ArrayList<>();

    public Boolean getAutoInvoiceMatchSwitch() {
        return autoInvoiceMatchSwitch;
    }

    public void setAutoInvoiceMatchSwitch(Boolean autoInvoiceMatchSwitch) {
        this.autoInvoiceMatchSwitch = autoInvoiceMatchSwitch;
    }

    public List<String> getAutoInvoiceMatchCondition() {
        return autoInvoiceMatchCondition;
    }

    public void setAutoInvoiceMatchCondition(List<String> autoInvoiceMatchCondition) {
        this.autoInvoiceMatchCondition = autoInvoiceMatchCondition;
    }

    public BigDecimal getAllowanceNum() {
        return allowanceNum;
    }

    public void setAllowanceNum(BigDecimal allowanceNum) {
        this.allowanceNum = allowanceNum;
    }

    public List<String> getInvoiceMatchOptionalFieldList() {
        return invoiceMatchOptionalFieldList;
    }

    public void setInvoiceMatchOptionalFieldList(List<String> invoiceMatchOptionalFieldList) {
        this.invoiceMatchOptionalFieldList = invoiceMatchOptionalFieldList;
    }

    public List<String> getInvoiceMatchStandardFieldList() {
        return invoiceMatchStandardFieldList;
    }

    public void setInvoiceMatchStandardFieldList(List<String> invoiceMatchStandardFieldList) {
        this.invoiceMatchStandardFieldList = invoiceMatchStandardFieldList;
    }

    @Override
    public String toString() {
        return "InvoiceMatchBillConfigDTO{" +
                "autoInvoiceMatchSwitch=" + autoInvoiceMatchSwitch +
                ", autoInvoiceMatchCondition=" + autoInvoiceMatchCondition +
                ", allowanceNum=" + allowanceNum +
                ", invoiceMatchOptionalFieldList=" + invoiceMatchOptionalFieldList +
                ", invoiceMatchStandardFieldList=" + invoiceMatchStandardFieldList +
                '}';
    }
}
