package com.xforceplus.seller.config.client.parse.impl;

import com.google.common.collect.Lists;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.parse.ConfigParser;
import com.xforceplus.seller.config.client.parse.bean.InvoiceInfoRuleDTO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Author zzw
 * @Description 发票票面配置规则解析
 * @Date
 * @return
 **/
@Component
public class InvoiceInfoRlueParser implements ConfigParser {
    private static final Logger logger = LoggerFactory.getLogger(InvoiceInfoRlueParser.class);

    @Override
    public InvoiceInfoRuleDTO parse(List<MsConfigItemBean> cfgConfigItemEntities) {
        InvoiceInfoRuleDTO invoiceInfoRuleDTO = new InvoiceInfoRuleDTO();
        if (CollectionUtils.isEmpty(cfgConfigItemEntities)) {
            return null;
        }
        for (MsConfigItemBean tmp : cfgConfigItemEntities) {
            invoiceInfoRuleDTO.setRuldId(tmp.getConfigId());
            String fieldName = tmp.getConfigItemName();
            if (StringUtils.isEmpty(fieldName)) {
                continue;
            }
            List<String> itemValueList = tmp.getConfigItemValue();
            if (CollectionUtils.isEmpty(itemValueList)) {
                logger.info("BillMergeParser--parse--itemValueList:null");
                itemValueList = Lists.newArrayList("");
            }
            String itemValue = itemValueList.get(0);
            if ("purchaserBankName".equals(fieldName)) {
                invoiceInfoRuleDTO.setPurchaserBankName(itemValue);
            }
            else if ("purchaserAddress".equals(fieldName)) {
                invoiceInfoRuleDTO.setPurchaserAddress(itemValue);
            }
            else if ("purchaserBankAccount".equals(fieldName)) {
                invoiceInfoRuleDTO.setPurchaserBankAccount(itemValue);
            }
            else if ("purchaserTel".equals(fieldName)) {
                invoiceInfoRuleDTO.setPurchaserTel(itemValue);
            }
            else if ("sellerBankName".equals(fieldName)) {
                invoiceInfoRuleDTO.setSellerBankName(itemValue);
            }
            else if ("sellerAddress".equals(fieldName)) {
                invoiceInfoRuleDTO.setSellerAddress(itemValue);
            }
            else if ("sellerBankAccount".equals(fieldName)) {
                invoiceInfoRuleDTO.setSellerBankAccount(itemValue);
            }
            else if ("sellerTel".equals(fieldName)) {
                invoiceInfoRuleDTO.setSellerTel(itemValue);
            }
            else if ("cashierName".equals(fieldName)) {
                invoiceInfoRuleDTO.setCashierName(itemValue);
            }
            else if ("checkerName".equals(fieldName)) {
                invoiceInfoRuleDTO.setCheckerName(itemValue);
            }
            else if ("invoicerName".equals(fieldName)) {
                invoiceInfoRuleDTO.setInvoicerName(itemValue);
            }
        }
        return invoiceInfoRuleDTO;
    }
}
