package com.xforceplus.seller.config.client.parse.impl;

import com.xforceplus.seller.config.client.configparser.EnumBean;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.parse.ConfigParser;
import com.xforceplus.seller.config.client.parse.bean.InvoiceProcessRuleDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Author zzw
 * @Description 发票流程处理规则 解析器
 * @Date
 * @return
 **/
@Component
public class InvoiceProcessRlueParser implements ConfigParser {
    private static final Logger logger = LoggerFactory.getLogger(InvoiceProcessRlueParser.class);

    @Override
    public InvoiceProcessRuleDTO parse(List<MsConfigItemBean> cfgConfigItemEntities) {
        InvoiceProcessRuleDTO invoiceProcessRuleDTO = new InvoiceProcessRuleDTO();
        for (MsConfigItemBean tmp : cfgConfigItemEntities) {
            invoiceProcessRuleDTO.setRuldId(tmp.getConfigId());
            String filedName = tmp.getConfigItemName();
            List<String> value = tmp.getConfigItemValue();
            if (filedName.equals("autoConfirm")) {
                EnumBean enumBean = EnumBean.transString2Enum(value.get(0));
                invoiceProcessRuleDTO.setAutoConfirm(Boolean.parseBoolean(value.get(0)));
             }
            else if (filedName.equals("autoConfirmBillUpdate")) {
                 invoiceProcessRuleDTO.setAutoConfirmBillUpdate( Boolean.parseBoolean(value.get(0)));
            }
            else if (filedName.equals("autoMerge")) {
                 invoiceProcessRuleDTO.setAutoMerge(Boolean.parseBoolean(value.get(0)));
             }
            else if (filedName.equals("autoMakeOut")) {
                 invoiceProcessRuleDTO.setAutoMakeOut(Boolean.parseBoolean(value.get(0)));
             }
            else if (filedName.equals("autoMergeFieldList")) {
                invoiceProcessRuleDTO.setAutoMergeFieldList(value);
            }
            else if (filedName.equals("preMakeOutInvoiceUpdateableFiledList")) {
                invoiceProcessRuleDTO.setPreMakeOutInvoiceUpdateableFiledList(value);
            }
            else if (filedName.equals("allowanceFlag")) {
                 invoiceProcessRuleDTO.setAllowanceFlag( Boolean.parseBoolean(value.get(0)));
             }
        }
        return invoiceProcessRuleDTO;
    }
}
