package com.xforceplus.seller.config.client.parse.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.xforceplus.phoenix.file.utils.CommonTools;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.parse.ConfigParser;
import com.xforceplus.seller.config.client.parse.bean.SysInfoRuleDTO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * @Author zzw
 * @Description 拆票规则解析器
 * @Date
 * @return
 **/
@Component
public class SysInfoRuleParser implements ConfigParser {
    private static final Logger logger = LoggerFactory.getLogger(SysInfoRuleParser.class);

    @Override
    public SysInfoRuleDTO parse(List<MsConfigItemBean> cfgConfigItemEntities) {

        SysInfoRuleDTO sysInfoRuleDTO = new SysInfoRuleDTO();
        for (MsConfigItemBean msConfigItemBean : cfgConfigItemEntities) {
            sysInfoRuleDTO.setRuldId(msConfigItemBean.getConfigId());
            String fieldName = msConfigItemBean.getConfigItemName();
            List<String> itemValueList = msConfigItemBean.getConfigItemValue();
            if (CommonTools.isEmpty(fieldName)){
                continue;
            }

            //当配置项值 设置了错误的格式，取出的集合是空则给一个默认值
            if (CollectionUtils.isEmpty(itemValueList)) {
                logger.warn("InvoiceSplitParse--parse--系统配置项值设置错误:null");
                itemValueList = Lists.newArrayList("");
            }
            String itemValue = itemValueList.get(0);
            if ("bill2PreviewInvoiceSkipFlag".equals(fieldName)) {
                sysInfoRuleDTO.setBill2PreviewInvoiceSkipFlag(Integer.parseInt(itemValue));
            }
            else if ("checkRedBillFalg".equals(fieldName)){
                 sysInfoRuleDTO.setCheckRedBillFalg(Boolean.parseBoolean(itemValue));
            }
            else if ("checkRedBillOriginInvoiceFalg".equals(fieldName)){
                 sysInfoRuleDTO.setCheckRedBillOriginInvoiceFalg(Boolean.parseBoolean(itemValue));
            }
            else if ("checkARBillPurchaseInfoFalg".equals(fieldName)){
                 sysInfoRuleDTO.setCheckARBillPurchaseInfoFalg(Boolean.parseBoolean(itemValue));
            }
            else if ("checkAPBillSellerInfoFalg".equals(fieldName)){
                 sysInfoRuleDTO.setCheckAPBillSellerInfoFalg(Boolean.parseBoolean(itemValue));
            }
            //TODO 很恶心的写法，但是没办法，不然要改很多别人的代码
            else if ("elecInvoiceRedFlushReleaseFalg".equals(fieldName)){
                if(!"".equals(itemValue)){
                    sysInfoRuleDTO.setElecInvoiceRedFlushReleaseFalg(itemValueList.stream().map(e->Integer.valueOf(e)).collect(Collectors.toList()));
                }
            } else if ("spePaperInoviceRedFlushReleaseFalg".equals(fieldName)){
                if(!"".equals(itemValue)){
                    sysInfoRuleDTO.setSpePaperInoviceRedFlushReleaseFalg(itemValueList.stream().map(e->Integer.valueOf(e)).collect(Collectors.toList()));
                }
            } else if ("spePaperInoviceDrawftReleaseFlag".equals(fieldName)){
                if(!"".equals(itemValue)){
                    sysInfoRuleDTO.setSpePaperInoviceDrawftReleaseFlag(itemValueList.stream().map(e->Integer.valueOf(e)).collect(Collectors.toList()));
                }
            } else if ("comPaperInoviceDrawftReleaseFlag".equals(fieldName)){
                if(!"".equals(itemValue)){
                    sysInfoRuleDTO.setComPaperInoviceDrawftReleaseFlag(itemValueList.stream().map(e->Integer.valueOf(e)).collect(Collectors.toList()));
                }
            }else if ("comPaperInvoiceRedFlushReleaseFlag".equals(fieldName)){
                if(!"".equals(itemValue)){
                    sysInfoRuleDTO.setComPaperInvoiceRedFlushReleaseFlag(itemValueList.stream().map(e->Integer.valueOf(e)).collect(Collectors.toList()));
                }
            }
            else if ("autoUpdateTaxCodeFlag".equals(fieldName)){
                 sysInfoRuleDTO.setAutoUpdateTaxCodeFlag(Boolean.parseBoolean(itemValue));
            }
            else if ("comInvoiceNeedShortNameFlag".equals(fieldName)){
                 sysInfoRuleDTO.setComInvoiceNeedShortNameFlag(Boolean.parseBoolean(itemValue));
            }
            else if ("reffiendOilMixOpenFlag".equals(fieldName)){
                 sysInfoRuleDTO.setReffiendOilMixOpenFlag(Boolean.parseBoolean(itemValue));
            }
            else if ("checkTaxRateByConvertCodeFlag".equals(fieldName)){
                 sysInfoRuleDTO.setCheckTaxRateByConvertCodeFlag(Boolean.parseBoolean(itemValue));
            }
            else if ("prePayCardAutoOneGoodFlag".equals(fieldName)){
                 sysInfoRuleDTO.setPrePayCardAutoOneGoodFlag(Boolean.parseBoolean(itemValue));
            }
            else if ("comInvoiceAllowSameSellerOrPurcherFlg".equals(fieldName)){
                 sysInfoRuleDTO.setComInvoiceAllowSameSellerOrPurcherFlg(Boolean.parseBoolean(itemValue));
            }
            else if ("paperInvoiceMakeAutosendPdfFlag".equals(fieldName)){
                sysInfoRuleDTO.setPaperInvoiceMakeAutosendPdfFlag(Boolean.parseBoolean(itemValue));
            }
            else if ("invoiceMakeRemindPrintBillBackGroundFlag".equals(fieldName)){
                 sysInfoRuleDTO.setInvoiceMakeRemindPrintBillBackGroundFlag(Boolean.parseBoolean(itemValue));
            }
            else if ("autoSplitPreCardFlag".equals(fieldName)){
                 sysInfoRuleDTO.setAutoSplitPreCardFlag(Boolean.parseBoolean(itemValue));
            }
            else if ("speInvoiceAllowSameSellerOrPurcharseFlag".equals(fieldName)){
                 sysInfoRuleDTO.setSpeInvoiceAllowSameSellerOrPurcharseFlag(Boolean.parseBoolean(itemValue));
            }
            else if ("invoiceLock".equals(fieldName)){
                 sysInfoRuleDTO.setInvoiceLock(Boolean.parseBoolean(itemValue));
            }
            else if ("elecInvoiceNeedShortNameFlag".equals(fieldName)){
                 sysInfoRuleDTO.setElecInvoiceNeedShortNameFlag(Boolean.parseBoolean(itemValue));
            }
            else if ("elecInvoiceMakeAutoSendEmailFlag".equals(fieldName)){
                 sysInfoRuleDTO.setElecInvoiceMakeAutoSendEmailFlag(Boolean.parseBoolean(itemValue));
            }
            else if ("speInvoiceNeedShortNameFlag".equals(fieldName)){
                 sysInfoRuleDTO.setSpeInvoiceNeedShortNameFlag(Boolean.parseBoolean(itemValue));
            }
            else if ("autoSplitDiscountFlag".equals(fieldName)){
                 sysInfoRuleDTO.setAutoSplitDiscountFlag(Boolean.parseBoolean(itemValue));

            }else if ("uploadNagertiveMixBillFlag".equals(fieldName)){
                //历史数据,可能没有这个配置项
                if (CommonTools.isEmpty(itemValue)){
                    logger.info("没有找到系统配置项uploadNagertiveMixBillFlag");
                    sysInfoRuleDTO.setUploadNagertiveMixBillFlag(false);
                }else {
                    sysInfoRuleDTO.setUploadNagertiveMixBillFlag(Boolean.parseBoolean(itemValue));
                }
            }else if ("uploadBillAutoConfirm".equals(fieldName)) {
                //历史数据,可能没有这个配置项
                if (CommonTools.isEmpty(itemValue)) {
                    logger.info("uploadBillAutoConfirm");
                    sysInfoRuleDTO.setUploadBillAutoConfirm(true);
                } else {
                    sysInfoRuleDTO.setUploadBillAutoConfirm(Boolean.parseBoolean(itemValue));
                }
            }else if("billTolerance".equals(fieldName)) {
                if (CommonTools.isEmpty(itemValue) || !Pattern.compile("^[0-9]\\d{0,13}(\\.\\d{0,4})?$").matcher(itemValue).matches()) {
                    logger.error("发票匹配业务单配置项值容差只能为2位小数金额数据，传入值：{}", itemValue);
                    itemValue = String.valueOf(0);
                }
                sysInfoRuleDTO.setBillTolerance(new BigDecimal(itemValue).setScale(2, 4));
            } else if ("sendToAntFlag".equals(fieldName)){
                sysInfoRuleDTO.setSendToAntFlag(Boolean.parseBoolean(itemValue));
            }else if ("sendMailFlag".equals(fieldName)){
                sysInfoRuleDTO.setSendMailFlag(itemValue);
            }else if("bizBillDiscountRate".equals(fieldName)){
                // 业务单折扣率
                if(!CommonTools.isEmpty(itemValue) ){
                    sysInfoRuleDTO.setBizBillDiscountRate(itemValue);
                }else {
                    sysInfoRuleDTO.setBizBillDiscountRate("1");
                }
            }else if("invoiceMatchTolerance".equals(fieldName)){
                if (CommonTools.isEmpty(itemValue) || !Pattern.compile("^[0-9]\\d{0,13}(\\.\\d{0,4})?$").matcher(itemValue).matches()) {
                    itemValue = String.valueOf(0);
                }
                sysInfoRuleDTO.setInvoiceMatchTolerance(new BigDecimal(itemValue).setScale(2, BigDecimal.ROUND_HALF_UP));
            }else if("reconFlag".equals(fieldName)){
                sysInfoRuleDTO.setReconFlag(Boolean.parseBoolean(itemValue));
            }else if ("updateARBillAndCasm".equals(fieldName)){
                if (StringUtils.isBlank(itemValue)){
                    itemValue ="false" ;
                }
                sysInfoRuleDTO.setUpdateARBillAndCasm(itemValue);
            }else if ("updateARBillAndGoods".equals(fieldName)){
                if (StringUtils.isBlank(itemValue)){
                    itemValue ="false" ;
                }
                sysInfoRuleDTO.setUpdateARBillAndGoods(itemValue);
            }else if ("redNoCompareTolerance".equals(fieldName)){
                if (CommonTools.isEmpty(itemValue) || !Pattern.compile("^[0-9]\\d{0,13}(\\.\\d{0,4})?$").matcher(itemValue).matches()) {
                    logger.error("红字信息比对容差只能为2位小数金额数据，传入值：{}", itemValue);
                    itemValue = String.valueOf(0);
                }
                sysInfoRuleDTO.setRedNoCompareTolerance(new BigDecimal(itemValue).setScale(2, 4));
            }else if("redInvoiceReason".equals(fieldName)){
                sysInfoRuleDTO.setRedInvoiceReason(itemValue);
            }else if("customerNo".equals(fieldName)){
                sysInfoRuleDTO.setCustomerNo(itemValue);
            }else if("invoiceTitlePhoneRequired".equals(fieldName)){
                sysInfoRuleDTO.setInvoiceTitlePhoneRequired(itemValue);
            }else if("invoiceTitleApplyInvoiceType".equals(fieldName)){
                if(!"".equals(itemValue)) {
                    sysInfoRuleDTO.setInvoiceTitleApplyInvoiceType(itemValueList);
                }
            }else if("followWechat".equals(fieldName)){
                sysInfoRuleDTO.setFollowWechat(itemValue);
            } else if("orderSearchCondition".equals(fieldName)){
                sysInfoRuleDTO.setOrderSearchCondition(itemValue);
            }else if("orderSearchSource".equals(fieldName)){
                sysInfoRuleDTO.setOrderSearchSource(itemValue);
            }else if("invoiceTitleCustomFieldName".equals(fieldName)){
                sysInfoRuleDTO.setInvoiceTitleCustomFieldName(itemValue);
            }else if("invoiceTitleCustomFieldRequired".equals(fieldName)){
                sysInfoRuleDTO.setInvoiceTitleCustomFieldRequired(itemValue);
            }else if("canRepeatInvoice".equals(fieldName)){
                sysInfoRuleDTO.setCanRepeatInvoice(itemValue);
            } else if ("uploadBillAutoMake-electronic".equals(fieldName)) {
                sysInfoRuleDTO.setUploadBillAutoMakeElectronic(itemValueList);
            } else if ("autoMakeTerminal".equals(fieldName)) {
                sysInfoRuleDTO.setAutoMakeTerminal(itemValue);
            } else if ("invoiceFixedGoodsNo".equals(fieldName)) {
                sysInfoRuleDTO.setInvoiceFixedGoodsNo(itemValue);
            }

        }
        return sysInfoRuleDTO;
    }
}
