package com.xforceplus.seller.config.client.util;

import com.xforceplus.seller.config.client.model.MsConfigBean;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/**
 * 反射工具
 */
public class ReflectUtil {

    /**
     * 根据属性名获取bean 属性值
     * @param obj
     * @param prop
     * @return
     */
    public static String getPropValue(Object obj, String prop) {
        Class userCla = (Class) obj.getClass();
        Field[] fs = userCla.getDeclaredFields();

        for (Field field : fs) {
            field.setAccessible(true);
            try {
                if (field.getName().equals(prop)) {
                    if(null != field.get(obj)){
                        return field.get(obj).toString();
                    }
                }
            } catch (IllegalArgumentException e) {
                e.printStackTrace();
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }


        return null;
    }

    /**
     * bean 转 map
     * @param bean
     * @return
     * @throws Exception
     */
    public static Map<String,String> bean2map(Object bean) throws Exception{
        Map<String,String> map = new HashMap<>();

        Class userCla = (Class) bean.getClass();
        Field[] fs = userCla.getDeclaredFields();
        for (Field field : fs) {
            field.setAccessible(true);
            if(null != field.get(bean)){
                map.put(field.getName(), field.get(bean).toString());
            }
        }

        return map;
    }

    public static void main(String[] args) throws Exception {
        MsConfigBean bean = new MsConfigBean();
        bean.setExt1("aaaa");
        bean.setExt2("bbbb");
        bean.setAttributes(new ArrayList<>(10));

        Map<String,String> map = bean2map(bean);
        System.out.println(map);
    }
}
