/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.client.matchparser.impl;

import com.xforceplus.seller.config.client.constant.BusinessSalesBillTypeEnum;
import com.xforceplus.seller.config.client.constant.ConfigTypeEnum;
import com.xforceplus.seller.config.client.matchparser.ConfigMatchParser;
import com.xforceplus.seller.config.client.model.MsConfigBean;
import com.xforceplus.seller.config.client.model.MsConfigBizBillAttribute;
import com.xforceplus.seller.config.client.parse.BaseRuleBean;
import com.xforceplus.seller.config.client.parse.ConfigParser;
import com.xforceplus.seller.config.client.util.ReflectUtil;
import com.xforceplus.xplatframework.utils.JsonUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ConfigMatchParserImpl
implements ConfigMatchParser {
    private Logger logger = LoggerFactory.getLogger(ConfigMatchParserImpl.class);

    @Override
    public BaseRuleBean configMatch(List<MsConfigBean> cfgConfigEntities, MsConfigBean cfgConfigEntity, ConfigParser configParser) {
        if (cfgConfigEntity.getConfigType().equals(ConfigTypeEnum.SPLIT_CONFIG_TYPE.getConfigType()) || cfgConfigEntity.getConfigType().equals(ConfigTypeEnum.INVOICE_USER_CONFIG_TYPE.getConfigType()) || cfgConfigEntity.getConfigType().equals(ConfigTypeEnum.INVOICE_CONFIG_TYPE.getConfigType()) || cfgConfigEntity.getConfigType().equals(ConfigTypeEnum.SYS_CONFIG_TYPE.getConfigType())) {
            return this.splitConfigRuleMatch(cfgConfigEntities, cfgConfigEntity, configParser);
        }
        int maxScore = 0;
        if (CollectionUtils.isEmpty(cfgConfigEntities)) {
            return null;
        }
        MsConfigBean result = cfgConfigEntities.get(0);
        this.logger.info("configMatch---cfgConfigEntity:{}", (Object)cfgConfigEntity);
        for (MsConfigBean tmp : cfgConfigEntities) {
            int score = this.matchSellerInfo(cfgConfigEntity, tmp);
            this.logger.info("configMatch--- matchSellerInfo tmp:{}--score:{}", (Object)JsonUtils.writeObjectToFastJson((Object)tmp), (Object)score);
            if (score == -1) continue;
            int matchPurchaserScore = this.matchPurchaserInfo(cfgConfigEntity, tmp);
            this.logger.info("configMatch--- matchPurchaserInfo tmp:{}--score:{}", (Object)JsonUtils.writeObjectToFastJson((Object)tmp), (Object)matchPurchaserScore);
            if (matchPurchaserScore == -1) continue;
            score += matchPurchaserScore;
            int matchExtScore = this.matchExtData(cfgConfigEntity, tmp);
            this.logger.info("configMatch--- matchExtData tmp:{}--score:{}", (Object)JsonUtils.writeObjectToFastJson((Object)tmp), (Object)matchExtScore);
            if (matchExtScore == -1 || (score += matchExtScore) <= maxScore) continue;
            maxScore = score;
            result = tmp;
            this.logger.info("matched configId====={}", (Object)tmp.getConfigId());
        }
        if (result == null) {
            return null;
        }
        this.logger.info("configMatch--- match result:{}", (Object)result);
        return configParser.parse(result.getItemList());
    }

    @Override
    public BaseRuleBean splitConfigRuleMatch(List<MsConfigBean> targetMsConfigBeanList, MsConfigBean msConfigBeanFromBill, ConfigParser configParser) {
        MsConfigBean retMsConfigBean = this.getBestMatchConfig(targetMsConfigBeanList, msConfigBeanFromBill);
        if (null == retMsConfigBean) {
            return null;
        }
        return configParser.parse(retMsConfigBean.getItemList());
    }

    private int matchSellerInfo(MsConfigBean sourceData, MsConfigBean targetData) {
        int score = 0;
        this.logger.info("sourceData.getSellerGroupId():{}, targetData.getSellerGroupId():{}", (Object)sourceData.getSellerGroupId(), (Object)targetData.getSellerGroupId());
        if (!sourceData.getSellerGroupId().equals(targetData.getSellerGroupId())) {
            return -1;
        }
        if (sourceData.getSellerGroupId().equals(targetData.getSellerGroupId())) {
            score = 2;
        }
        this.logger.info("sourceData.getPurchaserGroupId():{}, targetData.getPurchaserGroupId():{}", (Object)sourceData.getPurchaserGroupId(), (Object)targetData.getPurchaserGroupId());
        if (!sourceData.getPurchaserGroupId().equals(targetData.getPurchaserGroupId()) && sourceData.getPurchaserGroupId() != 0L) {
            return -1;
        }
        if (sourceData.getPurchaserGroupId().equals(targetData.getPurchaserGroupId())) {
            score = 2;
        }
        this.logger.info("sourceData.getSellerTaxNo():{}, targetData.getSellerTaxNo():{}", (Object)sourceData.getSellerTaxNo(), (Object)targetData.getSellerTaxNo());
        if (!StringUtils.isEmpty((CharSequence)sourceData.getSellerTaxNo()) && !targetData.getSellerTaxNo().equals(sourceData.getSellerTaxNo())) {
            return -1;
        }
        if (!StringUtils.isEmpty((CharSequence)sourceData.getSellerTaxNo()) && targetData.getSellerTaxNo().equals(sourceData.getSellerTaxNo())) {
            score = 160;
        }
        this.logger.info("sourceData.getSalesbillType():{}, targetData.getSalesbillType():{}", (Object)sourceData.getSalesbillType(), (Object)targetData.getSalesbillType());
        this.logger.info("sourceData.getPurchaserTaxNo():{}, targetData.getPurchaserTaxNo():{}", (Object)sourceData.getPurchaserTaxNo(), (Object)targetData.getPurchaserTaxNo());
        if (!StringUtils.isEmpty((CharSequence)sourceData.getPurchaserTaxNo()) && !targetData.getPurchaserTaxNo().equals(sourceData.getPurchaserTaxNo())) {
            return -1;
        }
        if (!StringUtils.isEmpty((CharSequence)sourceData.getPurchaserTaxNo()) && targetData.getPurchaserTaxNo().equals(sourceData.getPurchaserTaxNo())) {
            score = 160;
        }
        if (!StringUtils.isEmpty((CharSequence)sourceData.getSalesbillType()) && !targetData.getSalesbillType().equals(sourceData.getSalesbillType())) {
            return -1;
        }
        if (!StringUtils.isEmpty((CharSequence)sourceData.getSalesbillType()) && targetData.getSalesbillType().equals(sourceData.getSalesbillType())) {
            score += 4;
        }
        return score;
    }

    private int matchPurchaserInfo(MsConfigBean sourceData, MsConfigBean targetData) {
        Integer score = 0;
        Long sourcePurchaserGroupId = sourceData.getPurchaserGroupId();
        Long targePurchaserGroupId = targetData.getPurchaserGroupId();
        String sourcePurchaserNo = sourceData.getPurchaserNo();
        String targePurchaserNo = targetData.getPurchaserNo();
        Long sourceSellerGroupId = sourceData.getSellerGroupId();
        Long targeSellerGroupId = targetData.getSellerGroupId();
        String sourceSellerNo = sourceData.getSellerNo();
        String targeSellerNo = targetData.getSellerNo();
        String sourceBillType = sourceData.getSalesbillType();
        String targeBillType = targetData.getSalesbillType();
        this.logger.info("targePurchaserGroupId==={}, sourcePurchaserGroupId==={}", (Object)targePurchaserGroupId, (Object)sourcePurchaserGroupId);
        if (sourcePurchaserGroupId != null) {
            if (!targePurchaserGroupId.equals(sourcePurchaserGroupId)) {
                return -1;
            }
            score = 2;
        }
        this.logger.info("targeSellerGroupId==={}, sourceSellerGroupId==={}", (Object)targeSellerGroupId, (Object)sourceSellerGroupId);
        if (sourceSellerGroupId != null) {
            if (!targeSellerGroupId.equals(sourceSellerGroupId)) {
                return -1;
            }
            score = 2;
        }
        this.logger.info("sourcePurchaserNo==={}, targePurchaserNo==={}", (Object)sourcePurchaserNo, (Object)targePurchaserNo);
        if (!StringUtils.isEmpty((CharSequence)sourcePurchaserNo)) {
            if (!StringUtils.equals((CharSequence)sourcePurchaserNo, (CharSequence)targePurchaserNo)) {
                return -1;
            }
            score = 2;
        }
        this.logger.info("sourceSellerNo==={}, targeSellerNo==={}", (Object)sourceSellerNo, (Object)targeSellerNo);
        if (!StringUtils.isEmpty((CharSequence)sourceSellerNo)) {
            if (!StringUtils.equals((CharSequence)sourceSellerNo, (CharSequence)targeSellerNo)) {
                return -1;
            }
            score = 2;
        }
        this.logger.info("sourceBillType==={}, targeBillType==={}", (Object)sourceBillType, (Object)targeBillType);
        if (!StringUtils.isEmpty((CharSequence)sourceBillType)) {
            if (!StringUtils.equals((CharSequence)sourceBillType, (CharSequence)targeBillType)) {
                return -1;
            }
            score = 4;
        }
        return score;
    }

    private int matchExtData(MsConfigBean sourceData, MsConfigBean targetData) {
        int score = 0;
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt2())) {
            if (!targetData.getExt2().equals(sourceData.getExt2())) {
                return -1;
            }
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt3())) {
            if (!targetData.getExt3().equals(sourceData.getExt3())) {
                return -1;
            }
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt4())) {
            if (!targetData.getExt4().equals(sourceData.getExt4())) {
                return -1;
            }
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt5())) {
            if (!targetData.getExt5().equals(sourceData.getExt5())) {
                return -1;
            }
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt6())) {
            if (!targetData.getExt6().equals(sourceData.getExt6())) {
                return -1;
            }
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt7())) {
            if (!targetData.getExt7().equals(sourceData.getExt7())) {
                return -1;
            }
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt8())) {
            if (!targetData.getExt8().equals(sourceData.getExt8())) {
                return -1;
            }
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt9())) {
            if (!targetData.getExt9().equals(sourceData.getExt9())) {
                return -1;
            }
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt10())) {
            if (!targetData.getExt10().equals(sourceData.getExt10())) {
                return -1;
            }
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt11())) {
            if (!targetData.getExt11().equals(sourceData.getExt11())) {
                return -1;
            }
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt12())) {
            if (!targetData.getExt12().equals(sourceData.getExt12())) {
                return -1;
            }
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt13())) {
            if (!targetData.getExt13().equals(sourceData.getExt13())) {
                return -1;
            }
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt14())) {
            if (!targetData.getExt14().equals(sourceData.getExt14())) {
                return -1;
            }
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt15())) {
            if (!targetData.getExt15().equals(sourceData.getExt15())) {
                return -1;
            }
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt16())) {
            if (!targetData.getExt16().equals(sourceData.getExt16())) {
                return -1;
            }
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt17())) {
            if (!targetData.getExt17().equals(sourceData.getExt17())) {
                return -1;
            }
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt18())) {
            if (!targetData.getExt18().equals(sourceData.getExt18())) {
                return -1;
            }
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt19())) {
            if (!targetData.getExt19().equals(sourceData.getExt19())) {
                return -1;
            }
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt20())) {
            if (!targetData.getExt20().equals(sourceData.getExt20())) {
                return -1;
            }
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt21())) {
            if (!targetData.getExt21().equals(sourceData.getExt21())) {
                return -1;
            }
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt22())) {
            if (!targetData.getExt22().equals(sourceData.getExt22())) {
                return -1;
            }
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt23())) {
            if (!targetData.getExt23().equals(sourceData.getExt23())) {
                return -1;
            }
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt24())) {
            if (!targetData.getExt24().equals(sourceData.getExt24())) {
                return -1;
            }
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt25())) {
            if (!targetData.getExt25().equals(sourceData.getExt25())) {
                return -1;
            }
            score = 6;
        }
        return score;
    }

    private int getScoreByExtFields(MsConfigBean sourceData, MsConfigBean targetData) {
        int score = 0;
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt2()) && targetData.getExt2().equals(sourceData.getExt2())) {
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt3()) && targetData.getExt3().equals(sourceData.getExt3())) {
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt4()) && targetData.getExt4().equals(sourceData.getExt4())) {
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt5()) && targetData.getExt5().equals(sourceData.getExt5())) {
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt6()) && targetData.getExt6().equals(sourceData.getExt6())) {
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt7()) && targetData.getExt7().equals(sourceData.getExt7())) {
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt8()) && targetData.getExt8().equals(sourceData.getExt8())) {
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt9()) && targetData.getExt9().equals(sourceData.getExt9())) {
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt10()) && targetData.getExt10().equals(sourceData.getExt10())) {
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt11()) && targetData.getExt11().equals(sourceData.getExt11())) {
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt12()) && targetData.getExt12().equals(sourceData.getExt12())) {
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt13()) && targetData.getExt13().equals(sourceData.getExt13())) {
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt14()) && targetData.getExt14().equals(sourceData.getExt14())) {
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt15()) && targetData.getExt15().equals(sourceData.getExt15())) {
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt16()) && targetData.getExt16().equals(sourceData.getExt16())) {
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt17()) && targetData.getExt17().equals(sourceData.getExt17())) {
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt18()) && targetData.getExt18().equals(sourceData.getExt18())) {
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt19()) && targetData.getExt19().equals(sourceData.getExt19())) {
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt20()) && targetData.getExt20().equals(sourceData.getExt20())) {
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt21()) && targetData.getExt21().equals(sourceData.getExt21())) {
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt22()) && targetData.getExt22().equals(sourceData.getExt22())) {
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt23()) && targetData.getExt23().equals(sourceData.getExt23())) {
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt24()) && targetData.getExt24().equals(sourceData.getExt24())) {
            score = 6;
        }
        if (!StringUtils.isEmpty((CharSequence)targetData.getExt25()) && targetData.getExt25().equals(sourceData.getExt25())) {
            score = 6;
        }
        return score;
    }

    @Override
    public MsConfigBean getBestMatchConfig(List<MsConfigBean> targetMsConfigBeanList, MsConfigBean msConfigBeanFromBill) {
        if (CollectionUtils.isEmpty(targetMsConfigBeanList)) {
            return null;
        }
        int maxScore = 0;
        MsConfigBean retMsConfigBean = null;
        Map<String, String> bean = null;
        try {
            bean = ReflectUtil.bean2map(msConfigBeanFromBill);
        }
        catch (Exception e) {
            this.logger.error("@getBestMatchConfig ", (Throwable)e);
        }
        for (MsConfigBean matchingMsConfigBean : targetMsConfigBeanList) {
            String bBillType;
            int score = 0;
            boolean match = true;
            List<MsConfigBizBillAttribute> attributes = matchingMsConfigBean.getAttributes();
            if (!CollectionUtils.isEmpty(attributes)) {
                int matchCount = 0;
                for (MsConfigBizBillAttribute attr : attributes) {
                    String value = bean.get(attr.getFieldName());
                    if (value == null || !value.equals(attr.getValue())) {
                        match = false;
                        score -= 6;
                        break;
                    }
                    ++matchCount;
                }
                if (!match) continue;
                score += 6 * matchCount;
            }
            if ((bBillType = matchingMsConfigBean.getBusinessBillType()).equals(BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType())) {
                if (null != matchingMsConfigBean.getSellerGroupId() && matchingMsConfigBean.getSellerGroupId() > 0L && matchingMsConfigBean.getSellerGroupId().equals(msConfigBeanFromBill.getSellerGroupId())) {
                    score += 2;
                } else {
                    this.logger.info("AR---\u9500\u65b9\u96c6\u56e2Id \u4e0d\u76f8\u7b49\uff0c\u653e\u5f03\u672c\u6b21\u7684\u5339\u914d\u89c4\u5219\uff0c \u6309\u7b5b\u9009\u6761\u4ef6\uff0c\u4e0d\u53ef\u80fd\u8fd0\u884c\u5230\u8be5\u5206\u652f configId:{}", (Object)(matchingMsConfigBean == null ? null : matchingMsConfigBean.getConfigId()));
                    continue;
                }
                if (!StringUtils.isEmpty((CharSequence)matchingMsConfigBean.getSellerTaxNo()) && matchingMsConfigBean.getSellerTaxNo().equals(msConfigBeanFromBill.getSellerTaxNo())) {
                    score += 160;
                } else if (!StringUtils.isEmpty((CharSequence)matchingMsConfigBean.getSellerTaxNo())) {
                    this.logger.info("AR---\u9500\u65b9\u96c6\u56e2Id\u76f8\u7b49\u3001\u516c\u53f8\u6709\u503c\u4e14\u4e0d\u76f8\u7b49\uff1a\u8be5\u89c4\u5219\u4e0d\u4f7f\u7528 configId:{}", (Object)(matchingMsConfigBean == null ? null : matchingMsConfigBean.getConfigId()));
                    continue;
                }
                if (matchingMsConfigBean.getSysOrgId() != null && matchingMsConfigBean.getSysOrgId() != 0L && matchingMsConfigBean.getSysOrgId().equals(msConfigBeanFromBill.getSysOrgId())) {
                    score += 160;
                } else if (matchingMsConfigBean.getSysOrgId() != null && matchingMsConfigBean.getSysOrgId() != 0L) {
                    this.logger.info("AR---\u9500\u65b9\u96c6\u56e2Id\u76f8\u7b49\u3001\u7ec4\u7ec7\u6709\u503c\u4e14\u4e0d\u76f8\u7b49\uff1a\u8be5\u89c4\u5219\u4e0d\u4f7f\u7528 configId:{}", (Object)(matchingMsConfigBean == null ? null : matchingMsConfigBean.getConfigId()));
                    continue;
                }
                if (null != matchingMsConfigBean.getPurchaserGroupId() && matchingMsConfigBean.getPurchaserGroupId() > 0L && matchingMsConfigBean.getPurchaserGroupId().equals(msConfigBeanFromBill.getPurchaserGroupId())) {
                    score += 2;
                } else if (null != matchingMsConfigBean.getPurchaserGroupId() && matchingMsConfigBean.getPurchaserGroupId() > 0L) {
                    this.logger.info("AR---\u8d2d\u65b9\u96c6\u56e2\u6709\u503c\u4e14\u4e0d\u76f8\u7b49\uff0c\u8be5\u4e2d\u89c4\u5219\u914d\u7f6e\u4e0d\u4f7f\u7528 configId:{}--msConfigBeanFromBill:{}", (Object)(matchingMsConfigBean == null ? null : matchingMsConfigBean.getConfigId()), (Object)JsonUtils.writeObjectToFastJson((Object)msConfigBeanFromBill));
                    continue;
                }
                if (!StringUtils.isEmpty((CharSequence)matchingMsConfigBean.getPurchaserTaxNo()) && matchingMsConfigBean.getPurchaserTaxNo().equals(msConfigBeanFromBill.getPurchaserTaxNo())) {
                    score += 160;
                } else if (!StringUtils.isEmpty((CharSequence)matchingMsConfigBean.getPurchaserTaxNo())) {
                    this.logger.info("AR---\u8d2d\u65b9\u516c\u53f8\u6709\u503c \u4e14 \u4e0d\u76f8\u7b49\u3001\u8be5\u4e2d\u89c4\u5219\u914d\u7f6e\u4e0d\u4f7f\u7528 configId:{}", (Object)(matchingMsConfigBean == null ? null : matchingMsConfigBean.getConfigId()));
                    continue;
                }
                ++score;
            } else {
                if (null != matchingMsConfigBean.getPurchaserGroupId() && matchingMsConfigBean.getPurchaserGroupId() > 0L && matchingMsConfigBean.getPurchaserGroupId().equals(msConfigBeanFromBill.getPurchaserGroupId())) {
                    score += 2;
                } else {
                    this.logger.info("AP---\u8d2d\u65b9\u96c6\u56e2Id \u4e0d\u76f8\u7b49\uff0c\u653e\u5f03\u672c\u6b21\u7684\u5339\u914d\u89c4\u5219\uff0c \u6309\u7b5b\u9009\u6761\u4ef6\uff0c\u4e0d\u53ef\u80fd\u8fd0\u884c\u5230\u8be5\u5206\u652f configId:{}", (Object)(matchingMsConfigBean == null ? null : matchingMsConfigBean.getConfigId()));
                    continue;
                }
                if (!StringUtils.isEmpty((CharSequence)matchingMsConfigBean.getPurchaserTaxNo()) && matchingMsConfigBean.getPurchaserTaxNo().equals(msConfigBeanFromBill.getPurchaserTaxNo())) {
                    score += 160;
                } else if (!StringUtils.isEmpty((CharSequence)matchingMsConfigBean.getPurchaserTaxNo())) {
                    this.logger.info("AP---\u9500\u65b9\u96c6\u56e2Id\u76f8\u7b49\u3001\u516c\u53f8\u6709\u503c\u4e14\u4e0d\u76f8\u7b49\uff1a\u8be5\u89c4\u5219\u4e0d\u4f7f\u7528 configId:{}", (Object)(matchingMsConfigBean == null ? null : matchingMsConfigBean.getConfigId()));
                    continue;
                }
                if (null != matchingMsConfigBean.getSellerGroupId() && matchingMsConfigBean.getSellerGroupId() > 0L && matchingMsConfigBean.getSellerGroupId().equals(msConfigBeanFromBill.getSellerGroupId())) {
                    score += 2;
                } else if (null != matchingMsConfigBean.getSellerGroupId() && matchingMsConfigBean.getSellerGroupId() > 0L) {
                    this.logger.info("AP---\u9500\u65b9\u96c6\u56e2\u6709\u503c\u4e14\u4e0d\u76f8\u7b49\uff0c\u8be5\u4e2d\u89c4\u5219\u914d\u7f6e\u4e0d\u4f7f\u7528 configId:{}", (Object)(matchingMsConfigBean == null ? null : matchingMsConfigBean.getConfigId()));
                    continue;
                }
                if (!StringUtils.isEmpty((CharSequence)matchingMsConfigBean.getSellerTaxNo()) && matchingMsConfigBean.getSellerTaxNo().equals(msConfigBeanFromBill.getSellerTaxNo())) {
                    score += 160;
                } else if (!StringUtils.isEmpty((CharSequence)matchingMsConfigBean.getSellerTaxNo())) {
                    this.logger.info("AP---\u8d2d\u65b9\u516c\u53f8\u6709\u503c \u4e14 \u4e0d\u76f8\u7b49\u3001\u8be5\u4e2d\u89c4\u5219\u914d\u7f6e\u4e0d\u4f7f\u7528 configId:{}", (Object)(matchingMsConfigBean == null ? null : matchingMsConfigBean.getConfigId()));
                    continue;
                }
            }
            if (!StringUtils.isEmpty((CharSequence)matchingMsConfigBean.getSalesbillType()) && matchingMsConfigBean.getSalesbillType().equals(msConfigBeanFromBill.getSalesbillType())) {
                score += 4;
            } else if (!StringUtils.isEmpty((CharSequence)matchingMsConfigBean.getSalesbillType())) {
                this.logger.info("ARAP---\u9500\u65b9\u96c6\u56e2Id\u76f8\u7b49\u3001\u516c\u53f8\u6709\u503c\u4e14\u76f8\u7b49\u3001\u5b50\u7ec4\u7ec7\u6709\u503c\u4e14\u76f8\u7b49\u3001 \u4e1a\u52a1\u7c7b\u578b\u6709\u503c\u4e14\u4e0d\u7b49\uff1a\u8be5\u89c4\u5219\u4e0d\u4f7f\u7528 configId:{}", (Object)(matchingMsConfigBean == null ? null : matchingMsConfigBean.getConfigId()));
                continue;
            }
            this.logger.info("matched====total size:{}, configId:{}, score:{} : AR|AP:{}", new Object[]{targetMsConfigBeanList.size(), matchingMsConfigBean.getConfigId(), score += this.getScoreByExtFields(matchingMsConfigBean, msConfigBeanFromBill), matchingMsConfigBean.getBusinessBillType()});
            if (score <= maxScore) continue;
            maxScore = score;
            retMsConfigBean = matchingMsConfigBean;
        }
        this.logger.info("splitConfigRuleMatch--- match result retMsConfigBean===>:{}", (Object)JsonUtils.writeObjectToFastJson(retMsConfigBean));
        return retMsConfigBean;
    }
}

