/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.client.parse.impl;

import com.google.common.collect.Lists;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.parse.ConfigParser;
import com.xforceplus.seller.config.client.parse.bean.InvoiceInfoRuleDTO;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class InvoiceInfoRlueParser
implements ConfigParser {
    private static final Logger logger = LoggerFactory.getLogger(InvoiceInfoRlueParser.class);

    @Override
    public InvoiceInfoRuleDTO parse(List<MsConfigItemBean> cfgConfigItemEntities) {
        InvoiceInfoRuleDTO invoiceInfoRuleDTO = new InvoiceInfoRuleDTO();
        if (CollectionUtils.isEmpty(cfgConfigItemEntities)) {
            return null;
        }
        for (MsConfigItemBean tmp : cfgConfigItemEntities) {
            invoiceInfoRuleDTO.setRuldId(tmp.getConfigId());
            String fieldName = tmp.getConfigItemName();
            if (StringUtils.isEmpty((CharSequence)fieldName)) continue;
            ArrayList itemValueList = tmp.getConfigItemValue();
            if (CollectionUtils.isEmpty(itemValueList)) {
                logger.info("BillMergeParser--parse--itemValueList:null");
                itemValueList = Lists.newArrayList((Object[])new String[]{""});
            }
            String itemValue = itemValueList.get(0);
            if ("purchaserBankName".equals(fieldName)) {
                invoiceInfoRuleDTO.setPurchaserBankName(itemValue);
                continue;
            }
            if ("purchaserAddress".equals(fieldName)) {
                invoiceInfoRuleDTO.setPurchaserAddress(itemValue);
                continue;
            }
            if ("purchaserBankAccount".equals(fieldName)) {
                invoiceInfoRuleDTO.setPurchaserBankAccount(itemValue);
                continue;
            }
            if ("purchaserTel".equals(fieldName)) {
                invoiceInfoRuleDTO.setPurchaserTel(itemValue);
                continue;
            }
            if ("sellerBankName".equals(fieldName)) {
                invoiceInfoRuleDTO.setSellerBankName(itemValue);
                continue;
            }
            if ("sellerAddress".equals(fieldName)) {
                invoiceInfoRuleDTO.setSellerAddress(itemValue);
                continue;
            }
            if ("sellerBankAccount".equals(fieldName)) {
                invoiceInfoRuleDTO.setSellerBankAccount(itemValue);
                continue;
            }
            if ("sellerTel".equals(fieldName)) {
                invoiceInfoRuleDTO.setSellerTel(itemValue);
                continue;
            }
            if ("cashierName".equals(fieldName)) {
                invoiceInfoRuleDTO.setCashierName(itemValue);
                continue;
            }
            if ("checkerName".equals(fieldName)) {
                invoiceInfoRuleDTO.setCheckerName(itemValue);
                continue;
            }
            if (!"invoicerName".equals(fieldName)) continue;
            invoiceInfoRuleDTO.setInvoicerName(itemValue);
        }
        return invoiceInfoRuleDTO;
    }
}

