/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.client.parse.impl;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.file.utils.CommonTools;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.parse.ConfigParser;
import com.xforceplus.seller.config.client.parse.bean.SysInfoRuleDTO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SysInfoRuleParser
implements ConfigParser {
    private static final Logger logger = LoggerFactory.getLogger(SysInfoRuleParser.class);

    @Override
    public SysInfoRuleDTO parse(List<MsConfigItemBean> cfgConfigItemEntities) {
        SysInfoRuleDTO sysInfoRuleDTO = new SysInfoRuleDTO();
        for (MsConfigItemBean msConfigItemBean : cfgConfigItemEntities) {
            sysInfoRuleDTO.setRuldId(msConfigItemBean.getConfigId());
            String fieldName = msConfigItemBean.getConfigItemName();
            ArrayList itemValueList = msConfigItemBean.getConfigItemValue();
            if (CommonTools.isEmpty((String)fieldName)) continue;
            if (CollectionUtils.isEmpty(itemValueList)) {
                logger.warn("InvoiceSplitParse--parse--\u7cfb\u7edf\u914d\u7f6e\u9879\u503c\u8bbe\u7f6e\u9519\u8bef:null");
                itemValueList = Lists.newArrayList((Object[])new String[]{""});
            }
            String itemValue = itemValueList.get(0);
            if ("bill2PreviewInvoiceSkipFlag".equals(fieldName)) {
                sysInfoRuleDTO.setBill2PreviewInvoiceSkipFlag(Integer.parseInt(itemValue));
                continue;
            }
            if ("checkRedBillFalg".equals(fieldName)) {
                sysInfoRuleDTO.setCheckRedBillFalg(Boolean.parseBoolean(itemValue));
                continue;
            }
            if ("checkRedBillOriginInvoiceFalg".equals(fieldName)) {
                sysInfoRuleDTO.setCheckRedBillOriginInvoiceFalg(Boolean.parseBoolean(itemValue));
                continue;
            }
            if ("checkARBillPurchaseInfoFalg".equals(fieldName)) {
                sysInfoRuleDTO.setCheckARBillPurchaseInfoFalg(Boolean.parseBoolean(itemValue));
                continue;
            }
            if ("checkAPBillSellerInfoFalg".equals(fieldName)) {
                sysInfoRuleDTO.setCheckAPBillSellerInfoFalg(Boolean.parseBoolean(itemValue));
                continue;
            }
            if ("elecInvoiceRedFlushReleaseFalg".equals(fieldName)) {
                if ("".equals(itemValue)) continue;
                sysInfoRuleDTO.setElecInvoiceRedFlushReleaseFalg(itemValueList.stream().map(e -> Integer.valueOf(e)).collect(Collectors.toList()));
                continue;
            }
            if ("spePaperInoviceRedFlushReleaseFalg".equals(fieldName)) {
                if ("".equals(itemValue)) continue;
                sysInfoRuleDTO.setSpePaperInoviceRedFlushReleaseFalg(itemValueList.stream().map(e -> Integer.valueOf(e)).collect(Collectors.toList()));
                continue;
            }
            if ("spePaperInoviceDrawftReleaseFlag".equals(fieldName)) {
                if ("".equals(itemValue)) continue;
                sysInfoRuleDTO.setSpePaperInoviceDrawftReleaseFlag(itemValueList.stream().map(e -> Integer.valueOf(e)).collect(Collectors.toList()));
                continue;
            }
            if ("comPaperInoviceDrawftReleaseFlag".equals(fieldName)) {
                if ("".equals(itemValue)) continue;
                sysInfoRuleDTO.setComPaperInoviceDrawftReleaseFlag(itemValueList.stream().map(e -> Integer.valueOf(e)).collect(Collectors.toList()));
                continue;
            }
            if ("comPaperInvoiceRedFlushReleaseFlag".equals(fieldName)) {
                if ("".equals(itemValue)) continue;
                sysInfoRuleDTO.setComPaperInvoiceRedFlushReleaseFlag(itemValueList.stream().map(e -> Integer.valueOf(e)).collect(Collectors.toList()));
                continue;
            }
            if ("autoUpdateTaxCodeFlag".equals(fieldName)) {
                sysInfoRuleDTO.setAutoUpdateTaxCodeFlag(Boolean.parseBoolean(itemValue));
                continue;
            }
            if ("comInvoiceNeedShortNameFlag".equals(fieldName)) {
                sysInfoRuleDTO.setComInvoiceNeedShortNameFlag(Boolean.parseBoolean(itemValue));
                continue;
            }
            if ("reffiendOilMixOpenFlag".equals(fieldName)) {
                sysInfoRuleDTO.setReffiendOilMixOpenFlag(Boolean.parseBoolean(itemValue));
                continue;
            }
            if ("checkTaxRateByConvertCodeFlag".equals(fieldName)) {
                sysInfoRuleDTO.setCheckTaxRateByConvertCodeFlag(Boolean.parseBoolean(itemValue));
                continue;
            }
            if ("prePayCardAutoOneGoodFlag".equals(fieldName)) {
                sysInfoRuleDTO.setPrePayCardAutoOneGoodFlag(Boolean.parseBoolean(itemValue));
                continue;
            }
            if ("comInvoiceAllowSameSellerOrPurcherFlg".equals(fieldName)) {
                sysInfoRuleDTO.setComInvoiceAllowSameSellerOrPurcherFlg(Boolean.parseBoolean(itemValue));
                continue;
            }
            if ("paperInvoiceMakeAutosendPdfFlag".equals(fieldName)) {
                sysInfoRuleDTO.setPaperInvoiceMakeAutosendPdfFlag(Boolean.parseBoolean(itemValue));
                continue;
            }
            if ("invoiceMakeRemindPrintBillBackGroundFlag".equals(fieldName)) {
                sysInfoRuleDTO.setInvoiceMakeRemindPrintBillBackGroundFlag(Boolean.parseBoolean(itemValue));
                continue;
            }
            if ("autoSplitPreCardFlag".equals(fieldName)) {
                sysInfoRuleDTO.setAutoSplitPreCardFlag(Boolean.parseBoolean(itemValue));
                continue;
            }
            if ("speInvoiceAllowSameSellerOrPurcharseFlag".equals(fieldName)) {
                sysInfoRuleDTO.setSpeInvoiceAllowSameSellerOrPurcharseFlag(Boolean.parseBoolean(itemValue));
                continue;
            }
            if ("invoiceLock".equals(fieldName)) {
                sysInfoRuleDTO.setInvoiceLock(Boolean.parseBoolean(itemValue));
                continue;
            }
            if ("elecInvoiceNeedShortNameFlag".equals(fieldName)) {
                sysInfoRuleDTO.setElecInvoiceNeedShortNameFlag(Boolean.parseBoolean(itemValue));
                continue;
            }
            if ("elecInvoiceMakeAutoSendEmailFlag".equals(fieldName)) {
                sysInfoRuleDTO.setElecInvoiceMakeAutoSendEmailFlag(Boolean.parseBoolean(itemValue));
                continue;
            }
            if ("speInvoiceNeedShortNameFlag".equals(fieldName)) {
                sysInfoRuleDTO.setSpeInvoiceNeedShortNameFlag(Boolean.parseBoolean(itemValue));
                continue;
            }
            if ("autoSplitDiscountFlag".equals(fieldName)) {
                sysInfoRuleDTO.setAutoSplitDiscountFlag(Boolean.parseBoolean(itemValue));
                continue;
            }
            if ("uploadNagertiveMixBillFlag".equals(fieldName)) {
                if (CommonTools.isEmpty((String)itemValue)) {
                    logger.info("\u6ca1\u6709\u627e\u5230\u7cfb\u7edf\u914d\u7f6e\u9879uploadNagertiveMixBillFlag");
                    sysInfoRuleDTO.setUploadNagertiveMixBillFlag(false);
                    continue;
                }
                sysInfoRuleDTO.setUploadNagertiveMixBillFlag(Boolean.parseBoolean(itemValue));
                continue;
            }
            if ("uploadBillAutoConfirm".equals(fieldName)) {
                if (CommonTools.isEmpty((String)itemValue)) {
                    logger.info("uploadBillAutoConfirm");
                    sysInfoRuleDTO.setUploadBillAutoConfirm(true);
                    continue;
                }
                sysInfoRuleDTO.setUploadBillAutoConfirm(Boolean.parseBoolean(itemValue));
                continue;
            }
            if ("billTolerance".equals(fieldName)) {
                if (CommonTools.isEmpty((String)itemValue) || !Pattern.compile("^[0-9]\\d{0,13}(\\.\\d{0,4})?$").matcher(itemValue).matches()) {
                    logger.error("\u53d1\u7968\u5339\u914d\u4e1a\u52a1\u5355\u914d\u7f6e\u9879\u503c\u5bb9\u5dee\u53ea\u80fd\u4e3a2\u4f4d\u5c0f\u6570\u91d1\u989d\u6570\u636e\uff0c\u4f20\u5165\u503c\uff1a{}", (Object)itemValue);
                    itemValue = String.valueOf(0);
                }
                sysInfoRuleDTO.setBillTolerance(new BigDecimal(itemValue).setScale(2, 4));
                continue;
            }
            if ("sendToAntFlag".equals(fieldName)) {
                sysInfoRuleDTO.setSendToAntFlag(Boolean.parseBoolean(itemValue));
                continue;
            }
            if ("sendMailFlag".equals(fieldName)) {
                sysInfoRuleDTO.setSendMailFlag(itemValue);
                continue;
            }
            if ("bizBillDiscountRate".equals(fieldName)) {
                if (!CommonTools.isEmpty((String)itemValue)) {
                    sysInfoRuleDTO.setBizBillDiscountRate(itemValue);
                    continue;
                }
                sysInfoRuleDTO.setBizBillDiscountRate("1");
                continue;
            }
            if ("invoiceMatchTolerance".equals(fieldName)) {
                if (CommonTools.isEmpty((String)itemValue) || !Pattern.compile("^[0-9]\\d{0,13}(\\.\\d{0,4})?$").matcher(itemValue).matches()) {
                    itemValue = String.valueOf(0);
                }
                sysInfoRuleDTO.setInvoiceMatchTolerance(new BigDecimal(itemValue).setScale(2, 4));
                continue;
            }
            if ("reconFlag".equals(fieldName)) {
                sysInfoRuleDTO.setReconFlag(Boolean.parseBoolean(itemValue));
                continue;
            }
            if ("updateARBillAndCasm".equals(fieldName)) {
                if (StringUtils.isBlank((CharSequence)itemValue)) {
                    itemValue = "false";
                }
                sysInfoRuleDTO.setUpdateARBillAndCasm(itemValue);
                continue;
            }
            if ("updateARBillAndGoods".equals(fieldName)) {
                if (StringUtils.isBlank((CharSequence)itemValue)) {
                    itemValue = "false";
                }
                sysInfoRuleDTO.setUpdateARBillAndGoods(itemValue);
                continue;
            }
            if ("redNoCompareTolerance".equals(fieldName)) {
                if (CommonTools.isEmpty((String)itemValue) || !Pattern.compile("^[0-9]\\d{0,13}(\\.\\d{0,4})?$").matcher(itemValue).matches()) {
                    logger.error("\u7ea2\u5b57\u4fe1\u606f\u6bd4\u5bf9\u5bb9\u5dee\u53ea\u80fd\u4e3a2\u4f4d\u5c0f\u6570\u91d1\u989d\u6570\u636e\uff0c\u4f20\u5165\u503c\uff1a{}", (Object)itemValue);
                    itemValue = String.valueOf(0);
                }
                sysInfoRuleDTO.setRedNoCompareTolerance(new BigDecimal(itemValue).setScale(2, 4));
                continue;
            }
            if ("redInvoiceReason".equals(fieldName)) {
                sysInfoRuleDTO.setRedInvoiceReason(itemValue);
                continue;
            }
            if ("customerNo".equals(fieldName)) {
                sysInfoRuleDTO.setCustomerNo(itemValue);
                continue;
            }
            if ("invoiceTitlePhoneRequired".equals(fieldName)) {
                sysInfoRuleDTO.setInvoiceTitlePhoneRequired(itemValue);
                continue;
            }
            if ("invoiceTitleApplyInvoiceType".equals(fieldName)) {
                if ("".equals(itemValue)) continue;
                sysInfoRuleDTO.setInvoiceTitleApplyInvoiceType(itemValueList);
                continue;
            }
            if ("followWechat".equals(fieldName)) {
                sysInfoRuleDTO.setFollowWechat(itemValue);
                continue;
            }
            if ("orderSearchCondition".equals(fieldName)) {
                sysInfoRuleDTO.setOrderSearchCondition(itemValue);
                continue;
            }
            if ("orderSearchSource".equals(fieldName)) {
                sysInfoRuleDTO.setOrderSearchSource(itemValue);
                continue;
            }
            if ("invoiceTitleCustomFieldName".equals(fieldName)) {
                sysInfoRuleDTO.setInvoiceTitleCustomFieldName(itemValue);
                continue;
            }
            if ("invoiceTitleCustomFieldRequired".equals(fieldName)) {
                sysInfoRuleDTO.setInvoiceTitleCustomFieldRequired(itemValue);
                continue;
            }
            if ("canRepeatInvoice".equals(fieldName)) {
                sysInfoRuleDTO.setCanRepeatInvoice(itemValue);
                continue;
            }
            if ("uploadBillAutoMake-electronic".equals(fieldName)) {
                sysInfoRuleDTO.setUploadBillAutoMakeElectronic(itemValueList);
                continue;
            }
            if ("autoMakeTerminal".equals(fieldName)) {
                sysInfoRuleDTO.setAutoMakeTerminal(itemValue);
                continue;
            }
            if (!"invoiceFixedGoodsNo".equals(fieldName)) continue;
            sysInfoRuleDTO.setInvoiceFixedGoodsNo(itemValue);
        }
        return sysInfoRuleDTO;
    }
}

