/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.client.parse.impl;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.file.utils.CommonTools;
import com.xforceplus.seller.config.client.model.MatchFieldInfo;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.parse.ConfigParser;
import com.xforceplus.seller.config.client.parse.bean.InvoiceMatchBillConfigDTO;
import com.xforceplus.xplatframework.utils.JsonUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class InvoiceMatchBillParser
implements ConfigParser {
    private static final Logger logger = LoggerFactory.getLogger(InvoiceMatchBillParser.class);

    @Override
    public InvoiceMatchBillConfigDTO parse(List<MsConfigItemBean> cfgConfigItemEntities) {
        InvoiceMatchBillConfigDTO invoiceMatchBillConfigDTO = new InvoiceMatchBillConfigDTO();
        for (MsConfigItemBean msConfigItemBean : cfgConfigItemEntities) {
            invoiceMatchBillConfigDTO.setRuldId(msConfigItemBean.getConfigId());
            String fieldName = msConfigItemBean.getConfigItemName();
            ArrayList itemValueList = msConfigItemBean.getConfigItemValue();
            if (CollectionUtils.isEmpty(itemValueList)) {
                logger.info("configId:{}--InvoiceMatchBillParser--parse--\u53d1\u7968\u5339\u914d\u4e1a\u52a1\u5355\u914d\u7f6e\u9879\u503c\u8bbe\u7f6e\u9519\u8bef:null", (Object)msConfigItemBean.getConfigId());
                itemValueList = Lists.newArrayList((Object[])new String[]{""});
            }
            String itemValue = itemValueList.get(0);
            if ("autoInvoiceMatchSwitch".equals(fieldName)) {
                invoiceMatchBillConfigDTO.setAutoInvoiceMatchSwitch(Boolean.parseBoolean(itemValue));
                continue;
            }
            if ("autoInvoiceMatchCondition".equals(fieldName)) {
                invoiceMatchBillConfigDTO.setAutoInvoiceMatchCondition(itemValueList);
                continue;
            }
            if ("allowanceNum".equals(fieldName)) {
                if (CommonTools.isEmpty((String)itemValue) || !Pattern.compile("^[0-9]\\d{0,13}(\\.\\d{0,4})?$").matcher(itemValue).matches()) {
                    logger.error("\u53d1\u7968\u5339\u914d\u4e1a\u52a1\u5355\u914d\u7f6e\u9879\u503c\u5bb9\u5dee\u53ea\u80fd\u4e3a2\u4f4d\u5c0f\u6570\u91d1\u989d\u6570\u636e\uff0c\u4f20\u5165\u503c\uff1a{}", (Object)itemValue);
                    itemValue = String.valueOf(0);
                }
                invoiceMatchBillConfigDTO.setAllowanceNum(new BigDecimal(itemValue).setScale(2, 4));
                continue;
            }
            if ("invoiceMatchOptionalFieldList".equals(fieldName)) {
                invoiceMatchBillConfigDTO.setInvoiceMatchOptionalFieldList(itemValueList);
                continue;
            }
            if (!"invoiceMatchStandardFieldList".equals(fieldName)) continue;
            ArrayList fieldNameList = Lists.newArrayList();
            if (!CollectionUtils.isEmpty((Collection)itemValueList)) {
                for (String fieldNameInfo : itemValueList) {
                    try {
                        MatchFieldInfo matchFieldInfo = (MatchFieldInfo)JsonUtils.writeFastJsonToObject((String)fieldNameInfo, MatchFieldInfo.class);
                        if (Objects.isNull(matchFieldInfo) || Objects.isNull(matchFieldInfo.getField())) continue;
                        fieldNameList.add(matchFieldInfo.getField());
                    }
                    catch (Exception e) {
                        logger.error("InvoiceMatchBillConfigDTO fieldName {}", (Object)fieldNameInfo);
                    }
                }
            }
            invoiceMatchBillConfigDTO.setInvoiceMatchStandardFieldList(fieldNameList);
        }
        return invoiceMatchBillConfigDTO;
    }
}

