/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.client.parse.impl;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.file.utils.CommonTools;
import com.xforceplus.seller.config.client.constant.PriceMethodTypeEnum;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.parse.ConfigParser;
import com.xforceplus.seller.config.client.parse.bean.InvoiceSplitrRuleDTO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class InvoiceSplitParser
implements ConfigParser {
    private static final Logger logger = LoggerFactory.getLogger(InvoiceSplitParser.class);

    @Override
    public InvoiceSplitrRuleDTO parse(List<MsConfigItemBean> cfgConfigItemEntities) {
        InvoiceSplitrRuleDTO invoiceSplitrRuleDTO = new InvoiceSplitrRuleDTO();
        for (MsConfigItemBean tmp : cfgConfigItemEntities) {
            invoiceSplitrRuleDTO.setRuldId(tmp.getConfigId());
            String fieldName = tmp.getConfigItemName();
            ArrayList itemValueList = tmp.getConfigItemValue();
            if (CollectionUtils.isEmpty(itemValueList)) {
                itemValueList = Lists.newArrayList((Object[])new String[]{""});
            }
            String itemValue = itemValueList.get(0);
            if ("invoiceLimit".equals(fieldName)) {
                if (CommonTools.isEmpty((String)itemValue)) {
                    throw new RuntimeException("\u5f00\u7968\u9650\u989d\u5fc5\u586b\u9879");
                }
                if (new BigDecimal(itemValue).compareTo(BigDecimal.ZERO) <= 0) {
                    throw new RuntimeException("\u5f00\u7968\u9650\u989d\u5fc5\u987b\u5927\u4e8e0");
                }
                invoiceSplitrRuleDTO.setInvoiceLimit(new BigDecimal(itemValue));
                continue;
            }
            if ("priceMethod".equals(fieldName)) {
                if (!NumberUtils.isNumber((String)itemValue)) {
                    itemValue = "0";
                    logger.info("\u4ef7\u683c\u65b9\u5f0f\uff1a0-\u4e0d\u542b\u7a0e 1-\u542b\u7a0e \u5f53\u524d\u4f20\u5165\u503c\u4e0d\u5728\u8303\u56f4\u5185.\u4f7f\u7528\u9ed8\u8ba4\u4ef7\u683c\u65b9\u5f0f\uff1a0-\u4e0d\u542b\u7a0e");
                }
                PriceMethodTypeEnum priceMethodTypeEnum = PriceMethodTypeEnum.fromValue(Integer.parseInt(itemValue));
                invoiceSplitrRuleDTO.setPriceMethod(priceMethodTypeEnum);
                continue;
            }
            if ("splitFiledList".equals(fieldName)) {
                invoiceSplitrRuleDTO.setSplitFiledList(itemValueList);
                continue;
            }
            if ("discountRateLimit".equals(fieldName)) {
                BigDecimal discountRateLimit;
                if (!NumberUtils.isNumber((String)itemValue) || StringUtils.isEmpty((CharSequence)itemValue)) {
                    itemValue = "100";
                }
                if (BigDecimal.ZERO.compareTo(discountRateLimit = new BigDecimal(itemValue)) > 0 || new BigDecimal("100").compareTo(discountRateLimit) < 0) {
                    discountRateLimit = new BigDecimal("100");
                }
                invoiceSplitrRuleDTO.setDiscountRateLimit(discountRateLimit);
                continue;
            }
            if ("mergeBySplitField".equals(fieldName)) {
                int mergeBySplitField;
                if (!NumberUtils.isNumber((String)itemValue) || StringUtils.isEmpty((CharSequence)itemValue)) {
                    itemValue = "0";
                }
                if ((mergeBySplitField = Integer.parseInt(itemValue)) < 0 || mergeBySplitField > 1) {
                    mergeBySplitField = 0;
                }
                invoiceSplitrRuleDTO.setMergeBySplitField(mergeBySplitField != 0);
                continue;
            }
            if ("saleListOption".equals(fieldName)) {
                invoiceSplitrRuleDTO.setSaleListOption(itemValue);
                continue;
            }
            if ("discountMode".equals(fieldName)) {
                invoiceSplitrRuleDTO.setDiscountMode(itemValue);
                continue;
            }
            if ("taxDeviceType".equals(fieldName)) {
                invoiceSplitrRuleDTO.setTaxDeviceType(itemValue);
                continue;
            }
            if ("itemSort".equals(fieldName)) {
                invoiceSplitrRuleDTO.setItemSort(itemValue);
                continue;
            }
            if ("salesListMaxRow".equals(fieldName)) {
                if (null == itemValue || !Pattern.compile("^[\\d]*$").matcher(itemValue).matches()) {
                    logger.info("\u9500\u8d27\u6e05\u5355\u6700\u5927\u884c\u6570\u53ea\u80fd\u4e3a\u6574\u6570\uff0c\u4f20\u5165\u503c\uff1a{}", (Object)itemValue);
                    throw new RuntimeException("\u9500\u8d27\u6e05\u5355\u6700\u5927\u884c\u6570\u53ea\u80fd\u4e3a\u6574\u6570");
                }
                invoiceSplitrRuleDTO.setSalesListMaxRow(itemValue.equals("") ? 0 : Integer.parseInt(itemValue));
                continue;
            }
            if ("unitPriceAmountOps".equals(fieldName)) {
                invoiceSplitrRuleDTO.setUnitPriceAmountOps(itemValue);
                continue;
            }
            if ("amountSplitRule".equals(fieldName)) {
                invoiceSplitrRuleDTO.setAmountSplitRule(itemValue);
                continue;
            }
            if ("integerOps".equals(fieldName)) {
                invoiceSplitrRuleDTO.setIntegerOps(Boolean.parseBoolean(itemValue.equals("") ? "false" : itemValue));
                continue;
            }
            if ("invoiceItemMaxRow".equals(fieldName)) {
                if (CommonTools.isEmpty((String)itemValue)) {
                    throw new RuntimeException("\u7968\u9762\u884c\u6570\u5fc5\u586b\u9879");
                }
                if (new BigDecimal(itemValue).compareTo(BigDecimal.ZERO) < 0) {
                    throw new RuntimeException("\u7968\u9762\u884c\u6570\u4e0d\u80fd\u5c0f\u4e8e0");
                }
                invoiceSplitrRuleDTO.setInvoiceItemMaxRow(CommonTools.isEmpty((String)itemValue) ? 0 : Integer.parseInt(itemValue));
                continue;
            }
            if ("invoiceType".equals(fieldName)) {
                invoiceSplitrRuleDTO.setInvoiceType(itemValue);
                continue;
            }
            if ("invoiceRemarkFiledList".equals(fieldName)) {
                invoiceSplitrRuleDTO.setInvoiceRemarkFiledList(itemValueList);
                continue;
            }
            if ("invoiceItemRemarkFiledList".equals(fieldName)) {
                invoiceSplitrRuleDTO.setInvoiceItemRemarkFiledList(itemValueList);
                continue;
            }
            if ("goodsServicesNameFieldsList".equals(fieldName)) {
                invoiceSplitrRuleDTO.setGoodsServicesNameFieldsList(itemValueList);
                continue;
            }
            if ("itemSpecFieldsList".equals(fieldName)) {
                invoiceSplitrRuleDTO.setItemSpecFieldsList(itemValueList);
                continue;
            }
            if ("goodsServicesNameMainFieldsList".equals(fieldName)) {
                invoiceSplitrRuleDTO.setGoodsServicesNameMainFieldsList(itemValueList);
                continue;
            }
            if ("itemSpecMainFieldsList".equals(fieldName)) {
                invoiceSplitrRuleDTO.setItemSpecMainFieldsList(itemValueList);
                continue;
            }
            if ("customRemarkSize".equals(fieldName)) {
                if (CommonTools.isEmpty((String)itemValue)) continue;
                if (itemValue.matches("^-?\\d+$")) {
                    invoiceSplitrRuleDTO.setCustomRemarkSize(Integer.valueOf(itemValue));
                    continue;
                }
                throw new RuntimeException("\u81ea\u5b9a\u4e49\u5907\u6ce8\u957f\u5ea6\u5fc5\u987b\u4e3a\u6574\u6570");
            }
            if ("bizBillDiscountRate".equals(fieldName)) {
                if (!CommonTools.isEmpty((String)itemValue)) {
                    if (!itemValue.contains("%")) continue;
                    itemValue = StringUtils.replace((String)itemValue, (String)"%", (String)"");
                    invoiceSplitrRuleDTO.setBizBillDiscountRate(new BigDecimal(itemValue).divide(new BigDecimal("100")));
                    continue;
                }
                invoiceSplitrRuleDTO.setBizBillDiscountRate(new BigDecimal(itemValue));
                continue;
            }
            if ("ruleStrategy".equals(fieldName)) {
                invoiceSplitrRuleDTO.setRuleStrategy(itemValue);
                continue;
            }
            if ("priceScale".equals(fieldName)) {
                try {
                    invoiceSplitrRuleDTO.setPriceScale(Integer.parseInt(itemValue));
                }
                catch (Exception e) {
                    logger.error("\u89e3\u6790\u62c6\u7968\u89c4\u5219\u5355\u4ef7\u4f4d\u6570\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                    invoiceSplitrRuleDTO.setPriceScale(15);
                }
                continue;
            }
            if ("invoiceRemarkDistinctFlag".equals(fieldName)) {
                invoiceSplitrRuleDTO.setRemarkDuplicateFlag(Boolean.parseBoolean("".equals(itemValue) ? "true" : String.valueOf("1".equals(itemValue))));
                continue;
            }
            if ("taxAmountAllowMax".equals(fieldName)) {
                if (CommonTools.isEmpty((String)itemValue)) continue;
                try {
                    invoiceSplitrRuleDTO.setTaxAmountAllowMax(new BigDecimal(itemValue));
                }
                catch (Exception e) {
                    logger.error("\u7a0e\u989d\u8bef\u5dee\u5fc5\u987b\u4e3a\u6570\u503c\u4e14\u4e0d\u5927\u4e8e1.27", (Throwable)e);
                }
                continue;
            }
            if (!"taxInvoiceSource".equals(fieldName)) continue;
            invoiceSplitrRuleDTO.setTaxInvoiceSource(itemValue);
        }
        if (StringUtils.isEmpty((CharSequence)invoiceSplitrRuleDTO.getTaxInvoiceSource())) {
            invoiceSplitrRuleDTO.setTaxInvoiceSource("sk");
        }
        return invoiceSplitrRuleDTO;
    }
}

