/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.client;

import com.google.common.collect.Lists;
import com.xforceplus.seller.config.client.model.ConfigDataDTO;
import com.xforceplus.seller.config.client.model.ConfigItemDTO;
import com.xforceplus.seller.config.client.model.ConifgItemDataDTO;
import com.xforceplus.seller.config.client.model.ItemDTO;
import com.xforceplus.seller.config.client.model.MsConfigItemAddRequest;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.model.MsConfigItemResponse;
import com.xforceplus.seller.config.client.model.MsConfigItemTempBean;
import com.xforceplus.seller.config.client.model.MsTmpConfigAddRequest;
import com.xforceplus.xplatframework.utils.JsonUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ItemAssemble {
    public MsConfigItemAddRequest convert2ConfigItemRequest(ConfigItemDTO configItemDTO) {
        MsConfigItemAddRequest msConfigItemAddRequest = new MsConfigItemAddRequest();
        List<ItemDTO> itemDTOs = configItemDTO.getItemList();
        List<MsConfigItemBean> cfgConfigItemEntities = itemDTOs.stream().filter(Objects::nonNull).map(this::ItemDtoConvert2ConfigItemBean).collect(Collectors.toList());
        msConfigItemAddRequest.setItemDTOList(cfgConfigItemEntities);
        return msConfigItemAddRequest;
    }

    public MsTmpConfigAddRequest convert2TmpConfigItemRequest(ConfigItemDTO configItemDTO) {
        MsTmpConfigAddRequest msTmpConfigAddRequest = new MsTmpConfigAddRequest();
        List<ItemDTO> itemDTOs = configItemDTO.getItemList();
        msTmpConfigAddRequest.setInvoiceType(configItemDTO.getInvoiceType());
        List<MsConfigItemTempBean> cfgConfigItemEntities = itemDTOs.stream().filter(Objects::nonNull).map(this::ItemDtoConvert2TmpEntity).collect(Collectors.toList());
        msTmpConfigAddRequest.setEntityList(cfgConfigItemEntities);
        return msTmpConfigAddRequest;
    }

    public ConfigItemDTO convertItemDto(MsConfigItemResponse msConfigItemResponse) {
        List<MsConfigItemBean> entities = msConfigItemResponse.getResult();
        List<ItemDTO> itemDTOs = entities.stream().filter(Objects::nonNull).map(this::entityConvert2ItemDto).collect(Collectors.toList());
        ConfigItemDTO configItemDTO = new ConfigItemDTO();
        configItemDTO.setItemList(itemDTOs);
        return configItemDTO;
    }

    public ConfigDataDTO convertConfigItemDto(MsConfigItemResponse msConfigItemResponse) {
        List<MsConfigItemBean> entities = msConfigItemResponse.getResult();
        HashMap<String, ConifgItemDataDTO> map = new HashMap<String, ConifgItemDataDTO>();
        for (MsConfigItemBean tmp : entities) {
            ConifgItemDataDTO conifgItemDataDTO = this.entityConvert2ConifgItemDataDTO(tmp);
            map.put(tmp.getConfigItemName(), conifgItemDataDTO);
        }
        ConfigDataDTO configDataDTO = new ConfigDataDTO();
        configDataDTO.setConifgItemDataDTOs(Lists.newArrayList(map.values()));
        return configDataDTO;
    }

    private MsConfigItemBean ItemDtoConvert2ConfigItemBean(ItemDTO itemDTO) {
        MsConfigItemBean msConfigItemBean = new MsConfigItemBean();
        msConfigItemBean.setConfigItemDisplayName(itemDTO.getItemDisplayName());
        msConfigItemBean.setConfigItemName(itemDTO.getItemName());
        msConfigItemBean.setConfigItemValue(itemDTO.getValue());
        msConfigItemBean.setConfigId(itemDTO.getConfigId());
        return msConfigItemBean;
    }

    private MsConfigItemTempBean ItemDtoConvert2TmpEntity(ItemDTO itemDTO) {
        MsConfigItemTempBean msConfigItemTempBean = new MsConfigItemTempBean();
        msConfigItemTempBean.setConfigItemDisplayName(itemDTO.getItemDisplayName());
        msConfigItemTempBean.setConfigItemName(itemDTO.getItemName());
        msConfigItemTempBean.setConfigItemValue(itemDTO.getValue());
        msConfigItemTempBean.setConfigId(itemDTO.getConfigId());
        return msConfigItemTempBean;
    }

    private ConifgItemDataDTO entityConvert2ConifgItemDataDTO(MsConfigItemBean configItemBean) {
        List<String> itemValue = configItemBean.getConfigItemValue();
        ConifgItemDataDTO itemDTO = new ConifgItemDataDTO();
        itemDTO.setItemDisplayName(configItemBean.getConfigItemDisplayName());
        itemDTO.setItemName(configItemBean.getConfigItemName());
        itemDTO.setValue(itemValue);
        return itemDTO;
    }

    private ItemDTO entityConvert2ItemDto(MsConfigItemBean msConfigItemBean) {
        List<String> itemValue = msConfigItemBean.getConfigItemValue();
        ItemDTO itemDTO = new ItemDTO();
        itemDTO.setItemDisplayName(msConfigItemBean.getConfigItemDisplayName());
        itemDTO.setItemName(msConfigItemBean.getConfigItemName());
        itemDTO.setValue(itemValue);
        return itemDTO;
    }

    private String convertValueMap(ItemDTO itemDTO) {
        List<String> value = itemDTO.getValue();
        String dictCode = itemDTO.getDictCode();
        String min = itemDTO.getMin();
        String max = itemDTO.getMax();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((CharSequence)dictCode)) {
            map.put("dictCode", dictCode);
        }
        if (CollectionUtils.isEmpty(value)) {
            map.put("value", value);
        }
        if (!StringUtils.isEmpty((CharSequence)min)) {
            map.put("min", min);
        }
        if (!StringUtils.isEmpty((CharSequence)max)) {
            map.put("max", max);
        }
        return JsonUtils.writeObjectToFastJson(map);
    }
}

