/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.client.parse.impl;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.file.utils.CommonTools;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.parse.ConfigParser;
import com.xforceplus.seller.config.client.parse.bean.SmartMatchRuleDTO;
import com.xforceplus.xplatframework.utils.JsonUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SmartMatchRuleParser
implements ConfigParser {
    private static final Logger log = LoggerFactory.getLogger(SmartMatchRuleParser.class);

    @Override
    public SmartMatchRuleDTO parse(List<MsConfigItemBean> cfgConfigItemEntities) {
        if (CollectionUtils.isEmpty(cfgConfigItemEntities)) {
            return null;
        }
        SmartMatchRuleDTO smartMatchRuleDTO = new SmartMatchRuleDTO();
        for (MsConfigItemBean msConfigItemBean : cfgConfigItemEntities) {
            String value;
            smartMatchRuleDTO.setRuldId(msConfigItemBean.getConfigId());
            String fieldName = msConfigItemBean.getConfigItemName();
            if (StringUtils.isEmpty((CharSequence)fieldName)) continue;
            ArrayList itemValueList = msConfigItemBean.getConfigItemValue();
            if (CollectionUtils.isEmpty(itemValueList)) {
                log.info("RedConfirmParser--itemValueList--parse--Merge\u914d\u7f6e\u9879\u503c\u8bbe\u7f6e\u9519\u8bef:null");
                itemValueList = Lists.newArrayList((Object[])new String[]{""});
            }
            if (CommonTools.isEmpty((String)(value = itemValueList.get(0)))) continue;
            if ("findRule".equals(fieldName)) {
                try {
                    smartMatchRuleDTO.setFindRule(JsonUtils.writeJsonToListObject((String)value, SmartMatchRuleDTO.FindRuleItem.class));
                }
                catch (Exception e) {
                    log.error("\u89e3\u6790\u5339\u914d\u7b56\u7565\u5b57\u6bb5\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
                    throw new RuntimeException("\u89e3\u6790\u627e\u7968\u89c4\u5219\u5b57\u6bb5\u5f02\u5e38");
                }
            }
            if (!"calScoreRule".equals(fieldName)) continue;
            try {
                smartMatchRuleDTO.setCalScoreRule(JsonUtils.writeJsonToListObject((String)value, SmartMatchRuleDTO.CalScoreRuleItem.class));
            }
            catch (Exception e) {
                log.error("\u89e3\u6790\u5339\u914d\u7b56\u7565\u5b57\u6bb5\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
                throw new RuntimeException("\u89e3\u6790\u6253\u5206\u89c4\u5219\u5b57\u6bb5\u5f02\u5e38");
            }
        }
        return smartMatchRuleDTO;
    }
}

