/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.client.parse.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.phoenix.file.utils.CommonTools;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.parse.ConfigParser;
import com.xforceplus.seller.config.client.parse.bean.SysInfoRuleDTO;
import io.vavr.Lazy;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SysInfoRuleParser
implements ConfigParser {
    private static final Logger logger = LoggerFactory.getLogger(SysInfoRuleParser.class);
    private static final Map<String, BiConsumer<SysInfoRuleDTO, Boolean>> BOOL_VALUE_CONVERT_MAP = (Map)Lazy.of(() -> {
        HashMap map = Maps.newHashMap();
        map.put("checkRedBillFalg", SysInfoRuleDTO::setCheckRedBillFalg);
        map.put("checkRedBillOriginInvoiceFalg", SysInfoRuleDTO::setCheckRedBillOriginInvoiceFalg);
        map.put("checkARBillPurchaseInfoFalg", SysInfoRuleDTO::setCheckARBillPurchaseInfoFalg);
        map.put("checkAPBillSellerInfoFalg", SysInfoRuleDTO::setCheckAPBillSellerInfoFalg);
        map.put("autoUpdateTaxCodeFlag", SysInfoRuleDTO::setAutoUpdateTaxCodeFlag);
        map.put("comInvoiceNeedShortNameFlag", SysInfoRuleDTO::setComInvoiceNeedShortNameFlag);
        map.put("reffiendOilMixOpenFlag", SysInfoRuleDTO::setReffiendOilMixOpenFlag);
        map.put("checkTaxRateByConvertCodeFlag", SysInfoRuleDTO::setCheckTaxRateByConvertCodeFlag);
        map.put("prePayCardAutoOneGoodFlag", SysInfoRuleDTO::setPrePayCardAutoOneGoodFlag);
        map.put("comInvoiceAllowSameSellerOrPurcherFlg", SysInfoRuleDTO::setComInvoiceAllowSameSellerOrPurcherFlg);
        map.put("paperInvoiceMakeAutosendPdfFlag", SysInfoRuleDTO::setPaperInvoiceMakeAutosendPdfFlag);
        map.put("invoiceMakeRemindPrintBillBackGroundFlag", SysInfoRuleDTO::setInvoiceMakeRemindPrintBillBackGroundFlag);
        map.put("autoSplitPreCardFlag", SysInfoRuleDTO::setAutoSplitPreCardFlag);
        map.put("speInvoiceAllowSameSellerOrPurcharseFlag", SysInfoRuleDTO::setSpeInvoiceAllowSameSellerOrPurcharseFlag);
        map.put("invoiceLock", SysInfoRuleDTO::setInvoiceLock);
        map.put("elecInvoiceNeedShortNameFlag", SysInfoRuleDTO::setElecInvoiceNeedShortNameFlag);
        map.put("elecInvoiceMakeAutoSendEmailFlag", SysInfoRuleDTO::setElecInvoiceMakeAutoSendEmailFlag);
        map.put("speInvoiceNeedShortNameFlag", SysInfoRuleDTO::setSpeInvoiceNeedShortNameFlag);
        map.put("autoSplitDiscountFlag", SysInfoRuleDTO::setAutoSplitDiscountFlag);
        map.put("checkTerminalFailIssueRetry", SysInfoRuleDTO::setCheckTerminalFailIssueRetry);
        map.put("qdForceBackCalculateTaxAmount", SysInfoRuleDTO::setQdForceBackCalculateTaxAmount);
        map.put("mobileEmailFillingMethod", SysInfoRuleDTO::setMobileEmailFillingMethod);
        map.put("allowReissue", SysInfoRuleDTO::setAllowReissue);
        map.put("allowAddIssuer", SysInfoRuleDTO::setAllowAddIssuer);
        map.put("isAutoSelectIssuerFlag", SysInfoRuleDTO::setIsAutoSelectIssuerFlag);
        return map;
    }).get();
    private static final Map<String, BiConsumer<SysInfoRuleDTO, Boolean>> BOOL_VALUE_CONVERT_DEFAULT_FALSE_MAP = (Map)Lazy.of(() -> {
        HashMap map = Maps.newHashMap();
        map.put("uploadCheckByQd", SysInfoRuleDTO::setUploadCheckByQd);
        map.put("enableAdvancedValidation", SysInfoRuleDTO::setEnableAdvancedValidation);
        map.put("checkEIvoiceDisplayOthers", SysInfoRuleDTO::setCheckEIvoiceDisplayOthers);
        return map;
    }).get();

    @Override
    public SysInfoRuleDTO parse(List<MsConfigItemBean> cfgConfigItemEntities) {
        SysInfoRuleDTO sysInfoRuleDTO = new SysInfoRuleDTO();
        for (MsConfigItemBean msConfigItemBean : cfgConfigItemEntities) {
            sysInfoRuleDTO.setRuldId(msConfigItemBean.getConfigId());
            String fieldName = msConfigItemBean.getConfigItemName();
            ArrayList itemValueList = msConfigItemBean.getConfigItemValue();
            if (CommonTools.isEmpty((String)fieldName)) continue;
            if (CollectionUtils.isEmpty(itemValueList)) {
                logger.warn("InvoiceSplitParse--parse--\u7cfb\u7edf\u914d\u7f6e\u9879\u503c\u8bbe\u7f6e\u9519\u8bef:null");
                itemValueList = Lists.newArrayList((Object[])new String[]{""});
            }
            String itemValue = itemValueList.get(0);
            if ("bill2PreviewInvoiceSkipFlag".equals(fieldName)) {
                sysInfoRuleDTO.setBill2PreviewInvoiceSkipFlag(Integer.parseInt(itemValue));
            } else if ("elecInvoiceRedFlushReleaseFalg".equals(fieldName)) {
                if (!CommonTools.isEmpty((String)itemValue)) {
                    sysInfoRuleDTO.setElecInvoiceRedFlushReleaseFalg(itemValueList.stream().map(e -> Integer.valueOf(e)).collect(Collectors.toList()));
                }
            } else if ("spePaperInoviceRedFlushReleaseFalg".equals(fieldName)) {
                if (!CommonTools.isEmpty((String)itemValue)) {
                    sysInfoRuleDTO.setSpePaperInoviceRedFlushReleaseFalg(itemValueList.stream().map(e -> Integer.valueOf(e)).collect(Collectors.toList()));
                }
            } else if ("spePaperInoviceDrawftReleaseFlag".equals(fieldName)) {
                if (!CommonTools.isEmpty((String)itemValue)) {
                    sysInfoRuleDTO.setSpePaperInoviceDrawftReleaseFlag(itemValueList.stream().map(e -> Integer.valueOf(e)).collect(Collectors.toList()));
                }
            } else if ("comPaperInoviceDrawftReleaseFlag".equals(fieldName)) {
                if (!CommonTools.isEmpty((String)itemValue)) {
                    sysInfoRuleDTO.setComPaperInoviceDrawftReleaseFlag(itemValueList.stream().map(e -> Integer.valueOf(e)).collect(Collectors.toList()));
                }
            } else if ("comPaperInvoiceRedFlushReleaseFlag".equals(fieldName)) {
                if (!CommonTools.isEmpty((String)itemValue)) {
                    sysInfoRuleDTO.setComPaperInvoiceRedFlushReleaseFlag(itemValueList.stream().map(e -> Integer.valueOf(e)).collect(Collectors.toList()));
                }
            } else if ("vehicleInvoiceRedFlushReleaseFlag".equals(fieldName)) {
                if (!CommonTools.isEmpty((String)itemValue)) {
                    sysInfoRuleDTO.setVehicleInvoiceRedFlushReleaseFlag(itemValueList.stream().map(Integer::valueOf).collect(Collectors.toList()));
                }
            } else if ("uploadNagertiveMixBillFlag".equals(fieldName)) {
                if (CommonTools.isEmpty((String)itemValue)) {
                    logger.info("\u6ca1\u6709\u627e\u5230\u7cfb\u7edf\u914d\u7f6e\u9879uploadNagertiveMixBillFlag");
                    sysInfoRuleDTO.setUploadNagertiveMixBillFlag(false);
                } else {
                    sysInfoRuleDTO.setUploadNagertiveMixBillFlag(Boolean.parseBoolean(itemValue));
                }
            } else if ("uploadBillAutoConfirm".equals(fieldName)) {
                if (CommonTools.isEmpty((String)itemValue)) {
                    logger.info("uploadBillAutoConfirm");
                    sysInfoRuleDTO.setUploadBillAutoConfirm(true);
                } else {
                    sysInfoRuleDTO.setUploadBillAutoConfirm(Boolean.parseBoolean(itemValue));
                }
            } else if ("billTolerance".equals(fieldName)) {
                if (CommonTools.isEmpty((String)itemValue) || !Pattern.compile("^[0-9]\\d{0,13}(\\.\\d{0,4})?$").matcher(itemValue).matches()) {
                    logger.error("\u53d1\u7968\u5339\u914d\u4e1a\u52a1\u5355\u914d\u7f6e\u9879\u503c\u5bb9\u5dee\u53ea\u80fd\u4e3a2\u4f4d\u5c0f\u6570\u91d1\u989d\u6570\u636e\uff0c\u4f20\u5165\u503c\uff1a{}", (Object)itemValue);
                    itemValue = String.valueOf(0);
                }
                sysInfoRuleDTO.setBillTolerance(new BigDecimal(itemValue).setScale(2, 4));
            } else if ("sendToAntFlag".equals(fieldName)) {
                sysInfoRuleDTO.setSendToAntFlag(Boolean.parseBoolean(itemValue));
            } else if ("sendMailFlag".equals(fieldName)) {
                sysInfoRuleDTO.setSendMailFlag(itemValue);
            } else if ("bizBillDiscountRate".equals(fieldName)) {
                if (!CommonTools.isEmpty((String)itemValue)) {
                    sysInfoRuleDTO.setBizBillDiscountRate(itemValue);
                } else {
                    sysInfoRuleDTO.setBizBillDiscountRate("1");
                }
            } else if ("invoiceMatchTolerance".equals(fieldName)) {
                if (CommonTools.isEmpty((String)itemValue) || !Pattern.compile("^[0-9]\\d{0,13}(\\.\\d{0,4})?$").matcher(itemValue).matches()) {
                    itemValue = String.valueOf(0);
                }
                sysInfoRuleDTO.setInvoiceMatchTolerance(new BigDecimal(itemValue).setScale(2, 4));
            } else if ("reconFlag".equals(fieldName)) {
                sysInfoRuleDTO.setReconFlag(Boolean.parseBoolean(itemValue));
            } else if ("updateARBillAndCasm".equals(fieldName)) {
                if (StringUtils.isBlank((CharSequence)itemValue)) {
                    itemValue = "false";
                }
                sysInfoRuleDTO.setUpdateARBillAndCasm(itemValue);
            } else if ("updateARBillAndGoods".equals(fieldName)) {
                if (StringUtils.isBlank((CharSequence)itemValue)) {
                    itemValue = "false";
                }
                sysInfoRuleDTO.setUpdateARBillAndGoods(itemValue);
            } else if ("redNoCompareTolerance".equals(fieldName)) {
                if (CommonTools.isEmpty((String)itemValue) || !Pattern.compile("^[0-9]\\d{0,13}(\\.\\d{0,4})?$").matcher(itemValue).matches()) {
                    logger.error("\u7ea2\u5b57\u4fe1\u606f\u6bd4\u5bf9\u5bb9\u5dee\u53ea\u80fd\u4e3a2\u4f4d\u5c0f\u6570\u91d1\u989d\u6570\u636e\uff0c\u4f20\u5165\u503c\uff1a{}", (Object)itemValue);
                    itemValue = String.valueOf(0);
                }
                sysInfoRuleDTO.setRedNoCompareTolerance(new BigDecimal(itemValue).setScale(2, 4));
            } else if ("redInvoiceReason".equals(fieldName)) {
                sysInfoRuleDTO.setRedInvoiceReason(itemValue);
            } else if ("customerNo".equals(fieldName)) {
                sysInfoRuleDTO.setCustomerNo(itemValue);
            } else if ("invoiceTitlePhoneRequired".equals(fieldName)) {
                sysInfoRuleDTO.setInvoiceTitlePhoneRequired(itemValue);
            } else if ("invoiceTitleApplyInvoiceType".equals(fieldName)) {
                if (!"".equals(itemValue)) {
                    sysInfoRuleDTO.setInvoiceTitleApplyInvoiceType(itemValueList);
                }
            } else if ("followWechat".equals(fieldName)) {
                sysInfoRuleDTO.setFollowWechat(itemValue);
            } else if ("orderSearchCondition".equals(fieldName)) {
                sysInfoRuleDTO.setOrderSearchCondition(itemValue);
            } else if ("orderSearchSource".equals(fieldName)) {
                sysInfoRuleDTO.setOrderSearchSource(itemValue);
            } else if ("invoiceTitleCustomFieldName".equals(fieldName)) {
                sysInfoRuleDTO.setInvoiceTitleCustomFieldName(itemValue);
            } else if ("invoiceTitleCustomFieldRequired".equals(fieldName)) {
                sysInfoRuleDTO.setInvoiceTitleCustomFieldRequired(itemValue);
            } else if ("canRepeatInvoice".equals(fieldName)) {
                sysInfoRuleDTO.setCanRepeatInvoice(itemValue);
            } else if ("uploadBillAutoMake-electronic".equals(fieldName)) {
                sysInfoRuleDTO.setUploadBillAutoMakeElectronic(itemValueList);
            } else if ("autoMakeTerminal".equals(fieldName)) {
                sysInfoRuleDTO.setAutoMakeTerminal(itemValue);
            } else if ("invoiceFixedGoodsNo".equals(fieldName)) {
                sysInfoRuleDTO.setInvoiceFixedGoodsNo(itemValue);
            } else if ("goodsMatch".equals(fieldName)) {
                sysInfoRuleDTO.setGoodsMatch(itemValue);
            } else if ("bulkOrderQueryFlag".equals(fieldName)) {
                sysInfoRuleDTO.setBulkOrderQueryFlag(itemValue);
            } else if ("salesBillApplyInvoiceHint".equals(fieldName)) {
                sysInfoRuleDTO.setSalesBillApplyInvoiceHint(itemValue);
            } else if ("thirdPartyCode".equals(fieldName)) {
                sysInfoRuleDTO.setThirdPartyCode(itemValue);
            } else if ("rejectApplyRepeatFlag".equals(fieldName)) {
                sysInfoRuleDTO.setRejectApplyRepeatFlag(itemValueList);
            } else if ("billManualTag".equals(fieldName)) {
                sysInfoRuleDTO.setBillManualTag(NumberUtils.isCreatable((String)itemValue) ? Integer.parseInt(itemValue) : 2);
            } else if ("billManualTagRule".equals(fieldName)) {
                sysInfoRuleDTO.setBillManualTagRule(NumberUtils.isCreatable((String)itemValue) ? Integer.parseInt(itemValue) : 0);
            } else if (StringUtils.equals((CharSequence)"recommendGoodsType", (CharSequence)fieldName)) {
                sysInfoRuleDTO.setRecommendGoodsType(NumberUtils.isCreatable((String)itemValue) ? Integer.parseInt(itemValue) : 2);
            } else if (StringUtils.equals((CharSequence)"taxInvoiceSource", (CharSequence)fieldName)) {
                sysInfoRuleDTO.setTaxInvoiceSource(itemValue);
            } else if ("modifyTaxRateFlag".equals(fieldName)) {
                sysInfoRuleDTO.setModifyTaxRateFlag(NumberUtils.isCreatable((String)itemValue) ? Integer.parseInt(itemValue) : 0);
            } else if (StringUtils.equals((CharSequence)"qdSellerTitle", (CharSequence)fieldName)) {
                sysInfoRuleDTO.setQdSellerTitle(NumberUtils.isCreatable((String)itemValue) ? Integer.parseInt(itemValue) : 2);
            } else if (StringUtils.equals((CharSequence)"purchaserTitleMatchType", (CharSequence)fieldName)) {
                sysInfoRuleDTO.setPurchaserTitleMatchType(NumberUtils.isCreatable((String)itemValue) ? Integer.parseInt(itemValue) : 0);
            } else if ("speElecInvoiceRedFlushReleaseFlag".equals(fieldName)) {
                if (!CommonTools.isEmpty((String)itemValue)) {
                    sysInfoRuleDTO.setSpeElecInvoiceRedFlushReleaseFlag(itemValueList.stream().map(e -> Integer.valueOf(e)).collect(Collectors.toList()));
                }
            } else if ("sellerAndPurchaserControl".equals(fieldName)) {
                if (!CommonTools.isEmpty((String)itemValue)) {
                    sysInfoRuleDTO.setSellerAndPurchaserControl(itemValue);
                }
            } else if ("validSameStore".equals(fieldName)) {
                sysInfoRuleDTO.setValidSameStore(itemValue);
            } else if (StringUtils.equals((CharSequence)"taxInvoiceSourceForInterfaceRedFlush", (CharSequence)fieldName)) {
                sysInfoRuleDTO.setTaxInvoiceSourceForInterfaceRedFlush(itemValue);
            } else if (StringUtils.equals((CharSequence)"orgTypeView", (CharSequence)fieldName)) {
                sysInfoRuleDTO.setOrgTypeView(Integer.parseInt(itemValue));
            }
            this.boolValueConvert(sysInfoRuleDTO, fieldName, itemValue);
            this.boolValueConvertDefaultFalse(sysInfoRuleDTO, fieldName, itemValue);
        }
        return sysInfoRuleDTO;
    }

    private void boolValueConvert(SysInfoRuleDTO sysInfoRuleDTO, String fieldName, String itemValue) {
        Optional.ofNullable(BOOL_VALUE_CONVERT_MAP.get(fieldName)).ifPresent(consumer -> consumer.accept(sysInfoRuleDTO, Boolean.parseBoolean(itemValue)));
    }

    private void boolValueConvertDefaultFalse(SysInfoRuleDTO sysInfoRuleDTO, String fieldName, String itemValue) {
        Optional.ofNullable(BOOL_VALUE_CONVERT_DEFAULT_FALSE_MAP.get(fieldName)).ifPresent(consumer -> consumer.accept(sysInfoRuleDTO, "true".equals(itemValue)));
    }
}

