package com.xforceplus.seller.config.client.api;

import com.xforceplus.seller.config.client.model.*;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * 黑白名单公司
 */
@Api(value = "companyInfo", description = "the configImportReason API")
public interface CompanyInfoApi {


    @ApiOperation(
            value = "根据税号查询黑白名单",
            notes = "",
            response = ConfigCompanyQueryResponse.class,
            authorizations = {@Authorization("x-access-token")},
            tags = {"configCompany"}
    )
    @ApiResponses({@ApiResponse(
            code = 200,
            message = "查询结果",
            response = ConfigCompanyQueryResponse.class
    )})
    @RequestMapping(
            value = {"/query/companyInfo"},
            produces = {"application/json"},
            method = {RequestMethod.POST}
    )
    ConfigCompanyQueryResponse queryConfigCompany(@RequestBody ConfigCompanyQueryRequest request);

    @ApiOperation(
            value = "根据租户id查询黑白名单",
            notes = "",
            response = ConfigCompanyQueryResponse.class,
            authorizations = {@Authorization("x-access-token")},
            tags = {"configCompany"}
    )
    @ApiResponses({@ApiResponse(
            code = 200,
            message = "查询结果",
            response = Response.class
    )})
    @RequestMapping(
            value = {"/query/companyInfo/list"},
            produces = {"application/json"},
            method = {RequestMethod.POST}
    )
    Response queryCompanyList(@RequestBody CompanyPageQueryRequest request);

    @ApiOperation(
            value = "创建黑白名单",
            notes = "",
            response = ConfigCompanyQueryResponse.class,
            authorizations = {@Authorization("x-access-token")},
            tags = {"configCompany"}
    )
    @ApiResponses({@ApiResponse(
            code = 200,
            message = "查询结果",
            response = Response.class
    )})
    @RequestMapping(
            value = {"/companyInfo/create"},
            produces = {"application/json"},
            method = {RequestMethod.POST}
    )
    Response createCompanyInfo(@RequestBody CreateCompanyInfoRequest request);

    @ApiOperation(
            value = "删除黑白名单",
            notes = "",
            response = ConfigCompanyQueryResponse.class,
            authorizations = {@Authorization("x-access-token")},
            tags = {"configCompany"}
    )
    @ApiResponses({@ApiResponse(
            code = 200,
            message = "查询结果",
            response = Response.class
    )})
    @RequestMapping(
            value = {"/companyInfo/delete"},
            produces = {"application/json"},
            method = {RequestMethod.POST}
    )
    Response deleteCompanyInfo(@RequestBody DeleteCompanyInfoRequest request);

    @ApiOperation(
            value = "修改黑白名单",
            notes = "",
            response = ConfigCompanyQueryResponse.class,
            authorizations = {@Authorization("x-access-token")},
            tags = {"configCompany"}
    )
    @ApiResponses({@ApiResponse(
            code = 200,
            message = "查询结果",
            response = Response.class
    )})
    @RequestMapping(
            value = {"/companyInfo/update"},
            produces = {"application/json"},
            method = {RequestMethod.POST}
    )
    Response updateCompanyInfo(@RequestBody UpdateCompanyInfoRequest request);

}
