package com.xforceplus.seller.config.client.api;

import com.xforceplus.seller.config.client.model.MsQueryInvoiceTitleRequest;
import com.xforceplus.seller.config.client.model.MsQueryInvoiceTitleResponse;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


@Api(value = "configFirstIssuer", description = "the config API")
public interface ConfigFirstIssuerApi {

    @ApiOperation(value = "查询优先开票人信息", notes = "", response = MsQueryInvoiceTitleResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "SellerConfigTitle", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "统一返回", response = MsQueryInvoiceTitleResponse.class) })
    @RequestMapping(value = "/configFirstIssuer/queryFirstIssuer",
        produces = { "application/json" },
        method = RequestMethod.POST)
    MsQueryInvoiceTitleResponse queryFirstIssuer(@ApiParam(value = "查询优先开票人信息", required = true) @RequestBody MsQueryInvoiceTitleRequest msQueryInvoiceTitleRequest);
}
