package com.xforceplus.seller.config.client.api;

import com.xforceplus.openapi.domain.entity.common.BatchQueryDTO;
import com.xforceplus.seller.config.client.model.*;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public interface ConfigOpenApi {

    @ApiOperation(value = "openapi新增规则", response = ResponseV2.class, tags={ "ConfigOpen", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询响应", response = ResponseV2.class) })
    @RequestMapping(value = "/open/add",
            produces = { "application/json" },
            method = RequestMethod.POST)
    ResponseV2<String> addConfig(@RequestBody ConfigOpenAddRequest msConfigQueryRequest);

    @ApiOperation(value = "openapi全量更新规则", response = ResponseV2.class, tags={ "ConfigOpen", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询响应", response = ResponseV2.class) })
    @RequestMapping(value = "/open/update",
            produces = { "application/json" },
            method = RequestMethod.POST)
    ResponseV2<String> updateConfig(@RequestBody ConfigOpenUpdateRequest msConfigQueryRequest);

    @ApiOperation(value = "openapi查询规则", response = MsResponse.class, tags={ "ConfigOpen", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询响应", response = MsResponse.class) })
    @RequestMapping(value = "/open/query",
            produces = { "application/json" },
            method = RequestMethod.POST)
    ResponseV2<PageList<ConfigOpenFullDto>> queryConfig(@RequestBody BatchQueryDTO request);
}
