package com.xforceplus.seller.config.client.constant;


import com.xforceplus.phoenix.file.utils.CommonTools;

import java.util.stream.Stream;

/**
 * 项目名称: 票易通IMSC
 * 模块名称:
 * 说明:
 * JDK 版本: JDK1.8
 * 作者：liwei
 * 创建日期：2017/3/1
 */
public enum InvoiceType {
    /**
     * 未知发票类型
     */
    NONE("", "未知发票类型"),
    /**
     * 增值税普通发票
     */
    NORMAL("c", "增值税普通发票"),
    /**
     * 增值税专用发票
     */
    SPECIAL("s", "增值税专用发票"),
    /**
     * 增值税专用发票
     */
    SPECIAL_ELECTRONIC("se","增值税电子专用发票"),
    /**
     * 机动车销售发票
     */
    VEHICLE("v", "机动车销售发票"),
    /**
     * 通用机打发票
     */
    UNIVERSAL("t", "通用机打发票"),
    /**
     * 运输业增值税专用发票
     */
    TRANSPORTATION("y", "运输业增值税专用发票"),
    /**
     * 增值税电子普通发票
     */
    ELECTRONIC("ce", "增值税电子普通发票"),
    /**
     * 增值税普通发票(卷票)
     */
    ROLL("ju", "增值税普通发票(卷票)");


    private final String type;

    private final String description;


    InvoiceType(String type, String desc)
    {
        this.type = type;
        this.description = desc;
    }

    public String value()
    {
        return  this.type;
    }

    public String description(){return this.description;}

    public static InvoiceType fromValue(String value) throws RuntimeException{
        return Stream.of(InvoiceType.values())
                .filter(t -> t.value().equalsIgnoreCase(value))
                .findFirst().orElseThrow(() -> new RuntimeException("不存在对应类型的票"));
    }

    /**
     * 根据发票类型获取对应的描述
     * @param invoiceType
     * @return
     */
    public static String descriptionFromValue(String invoiceType){
        return Stream.of(InvoiceType.values())
                .filter(t -> t.value().equals(invoiceType))
                .findFirst().orElse(NONE).description();
    }

    /**
     * 是否是合法的发票类型
     * @param invoiceType 输入的发票类型
     * @return
     */
    public static boolean isValidInvoiceType(String invoiceType){
        if(CommonTools.isEmpty(invoiceType)){
            return false;
        }
        return Stream.of(InvoiceType.values())
                .filter(t -> t.value().equals(invoiceType))
                .findFirst().isPresent();
    }

    /**
     * 是否是普票
     * 包含普票，电票，卷票
     * @return
     */
    public boolean isNormal(){
        return this.equals(NORMAL) || this.equals(ELECTRONIC) || this.equals(ROLL);
    }


    /**
     * 是否是专票
     * @return
     */
    public boolean isSpecial(){
        return this.equals(SPECIAL);
    }
}
