package com.xforceplus.seller.config.client.constant;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

/**
 * 发票推送规则，邮件、短信地址类型
 */
@RequiredArgsConstructor
@Getter
public enum MailRuleAddressType implements ValueEnum<Integer> {
    BILL(0, "按业务单中的地址发送"),
    CUSTOMER(1, "按客商维护地址发送"),
    OTHER(2, "设置其他地址");

    private final Integer value;
    private final String description;
}
