package com.xforceplus.seller.config.client.constant;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

/**
 * 规则模版枚举
 */
@RequiredArgsConstructor
@Getter
public enum ObjCodeEnum implements ValueEnum<String> {
    BILL("bill", "单据主信息"),
    BILL_ITEM("billItem", "单据明细信息"),
    GOODS("goods", "商品"),
    TAXCODE("taxcode", "税编"),
    INVOICE("invoice", "发票页面"),
    SYS_CONFIG("sysConfig", "系统规则设置"),
    PAGE_PROCESS_CONFIG("pageProcssConfig", "票面规则配置"),
    INVOICE_INFO_CONFIG("invoiceInfoConfig", "票面信息配置"),
    INVOICE_MEMBER_INFO_CONFIG("invoiceMemberInfoConfig", "票面人员信息配置"),
    INVOICE_SPLIT_CONFIG("invoiceSplitConfig", "发票拆票规则"),
    BILL_SPLIT_CONFIG("billMergeSplitConfig", "单据拆合规则配置"),
    INVOICINGROLE("invoicingRole", "开票校验规则"),
    //贴原单和业务单类型底层复用一套数据结果，仅在使用时转换为对应的数据结构
    SOURCE_BILL("sourceBill", "贴原单信息"),
    ;

    private final String value;
    private final String description;

    /**
     * 4.1.28 后废弃
     */
    @Deprecated
    public String getObjCode() {
        return this.value;
    }

    /**
     * 4.1.28 后废弃
     */
    @Deprecated
    public String getObjCodeDesc() {
        return this.description;
    }
}
