package com.xforceplus.seller.config.client.constant;

/**
 * @Author chenlingwei
 * @create 2023/8/17 5:39 PM
 */
public enum SellerOrgTypeEnum {

    COMPANY("1", "公司"),
    TENANT("2", "租户"),
    ORGANIZATION("3", "组织");

    private String value;
    private String description;

    SellerOrgTypeEnum(String value, String valueDesc) {
        this.value = value;
        this.description = valueDesc;
    }

    public String getValue() {
        return value;
    }

    public String getDescription() {
        return description;
    }

    public static SellerOrgTypeEnum fromValue(String value) {
        SellerOrgTypeEnum[] valueEnums = SellerOrgTypeEnum.values();
        for (SellerOrgTypeEnum tmp : valueEnums) {
            if (tmp.getValue().equals(value)) {
                return tmp;
            }
        }
        return null;
    }
}
