package com.xforceplus.seller.config.client.constant.redconfirmmatch;

import com.google.common.collect.Lists;
import com.xforceplus.seller.config.client.constant.ValueEnum;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.util.List;

@RequiredArgsConstructor
@Getter
public enum MainMatchField implements ValueEnum<String> {

    identifyStatus("identifyStatus", "勾选状态", MainMatchFieldType.Enum, null, null),
    authTaxPeriod("authTaxPeriod", "增值税使用所属期", MainMatchFieldType.Month, Lists.newArrayList(24, 0), "yyyyMM");

    private final String value;
    private final String description;
    private final MainMatchFieldType type;
    private final List<Integer> timeRange;
    private final String monthPattern;
}
