package com.xforceplus.seller.config.client.constant.smartmatch;

import com.google.common.collect.Lists;
import com.xforceplus.seller.config.client.constant.ValueEnum;
import com.xforceplus.seller.config.client.constant.redconfirmmatch.MainMatchFieldType;
import com.xforceplus.seller.config.client.constant.redconfirmmatch.MatchTimeMode;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@Getter
@RequiredArgsConstructor
public enum SmartMatchField implements ValueEnum<String> {

    identifyStatus("identifyStatus", "勾选状态", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    authTaxPeriod("authTaxPeriod", "增值税使用所属期", MainMatchFieldType.Month, Lists.newArrayList(24, 0), "yyyyMM", SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    paperDrawDate("paperDrawDate", "蓝票开票日期", MainMatchFieldType.Timestamp, Lists.newArrayList(732, 0), null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    reversedRatio("reversedRatio", "明细红冲比例", MainMatchFieldType.Decimal, null, null, SmartMatchFieldKind.ITEM, SmartMatchFieldUseKind.SCORE),
    itemCode("itemCode", "货物及服务代码", MainMatchFieldType.String, null, null, SmartMatchFieldKind.ITEM, SmartMatchFieldUseKind.SCORE),
    itemName("itemName", "货物及服务名称", MainMatchFieldType.String, null, null, SmartMatchFieldKind.ITEM, SmartMatchFieldUseKind.SCORE),
    goodsTaxNo("goodsTaxNo", "税收分类编码", MainMatchFieldType.String, null, null, SmartMatchFieldKind.ITEM, SmartMatchFieldUseKind.SCORE),
    itemSpec("itemSpec", "规格型号", MainMatchFieldType.String, null, null, SmartMatchFieldKind.ITEM, SmartMatchFieldUseKind.SCORE),
    quantityUnit("quantityUnit", "数量单位", MainMatchFieldType.String, null, null, SmartMatchFieldKind.ITEM, SmartMatchFieldUseKind.SCORE),
    taxRate("taxRate", "税率", MainMatchFieldType.BigDecimal, null, null, SmartMatchFieldKind.ITEM, SmartMatchFieldUseKind.SCORE),
    unitPrice("unitPrice", "不含税单价", MainMatchFieldType.BigDecimal, null, null, SmartMatchFieldKind.ITEM, SmartMatchFieldUseKind.SCORE),
    //此处的扩展字段，仅定义是否可以使用。具体的使用情况见每个业务单类型的枚举扩展字段
    ext1("ext1", "扩展字段1", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext2("ext2", "扩展字段2", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext3("ext3", "扩展字段3", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext4("ext4", "扩展字段4", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext5("ext5", "扩展字段5", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext6("ext6", "扩展字段6", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext7("ext7", "扩展字段7", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext8("ext8", "扩展字段8", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext9("ext9", "扩展字段9", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext10("ext10", "扩展字段10", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext11("ext11", "扩展字段11", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext12("ext12", "扩展字段12", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext13("ext13", "扩展字段13", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext14("ext14", "扩展字段14", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext15("ext15", "扩展字段15", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext16("ext16", "扩展字段16", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext17("ext17", "扩展字段17", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext18("ext18", "扩展字段18", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext19("ext19", "扩展字段19", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext20("ext20", "扩展字段20", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext21("ext21", "扩展字段21", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext22("ext22", "扩展字段22", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext23("ext23", "扩展字段23", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext24("ext24", "扩展字段24", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext25("ext25", "扩展字段25", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER);

    private final String value;
    private final String description;
    private final MainMatchFieldType type;
    /**
     * 使用范围选择期的区间范围
     */
    private final List<Integer> timeRange;
    /**
     * 月份格式字段的格式
     */
    private final String monthPattern;
    /**
     * 主信息还是明细字段
     */
    private final SmartMatchFieldKind kind;
    /**
     * 用作过滤还是打分
     */
    private final SmartMatchFieldUseKind useKind;

    /**
     * 时间类型字段校验
     *
     * @param field 时间类型字段
     * @return 校验结果，有值则返回错误信息，空则校验成功
     */
    public static Optional<String> checkTimestampFieldTypeValue(final SmartMatchField field, final Integer timeMode, final List<String> valueList, final List<Integer> timeRange) {
        //时间类型校验
        final MatchTimeMode matchTimeMode = ValueEnum.getEnumByValue(MatchTimeMode.class, timeMode).orElse(null);
        if (MatchTimeMode.TIME == matchTimeMode) {
            List<Date> dateList = valueList.stream().map(r -> {
                try {
                    return new Date(Long.parseLong(r));
                } catch (Exception e) {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
            if (dateList.size() != 2) {
                return Optional.of(String.format("匹配字段：%s的时间选择器值有误", field.getDescription()));
            }
            if (dateList.get(0).compareTo(dateList.get(1)) > 0) {
                return Optional.of(String.format("匹配字段：%s的时间选择器值有误", field.getDescription()));
            }
            final LocalDateTime beginDate = LocalDateTime.ofInstant(dateList.get(0).toInstant(), ZoneId.systemDefault());
            final LocalDateTime endDate = LocalDateTime.ofInstant(dateList.get(1).toInstant(), ZoneId.systemDefault());
            int maxRangeDays = timeRange.get(0) - timeRange.get(1);
            if (Duration.between(beginDate, endDate).toDays() > maxRangeDays) {
                if (maxRangeDays < 365) {
                    return Optional.of(String.format("匹配字段：%s的时间选择器值超出规定范围，最大支持选择范围为%s天", field.getDescription(), maxRangeDays));
                } else {
                    return Optional.of(String.format("匹配字段：%s的时间选择器值超出规定范围，最大支持选择范围为%s年", field.getDescription(), maxRangeDays / 365));
                }
            }
        } else if (MatchTimeMode.RANGE == matchTimeMode) {
            List<Integer> rangeList = valueList.stream().map(r -> {
                try {
                    return Integer.parseInt(r);
                } catch (NumberFormatException e) {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
            if (rangeList.size() != 2) {
                return Optional.of(String.format("匹配字段：%s的范围选择器值有误", field.getDescription()));
            }
            if (rangeList.get(0) <= rangeList.get(1)) {
                return Optional.of(String.format("匹配字段：%s的范围选择器值有误", field.getDescription()));
            }
            if (rangeList.get(0) > timeRange.get(0) || rangeList.get(1) < timeRange.get(1)) {
                return Optional.of(String.format("匹配字段：%s的范围选择器值超出规定范围，默认为从%s到%s", field.getDescription(), timeRange.get(0), timeRange.get(1)));
            }
        } else {
            return Optional.of(String.format("匹配字段：%s的选择器类型有误", field.getDescription()));
        }

        return Optional.empty();
    }
}
