package com.xforceplus.seller.config.client.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

@ApiModel("全电开票人信息")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class AllElectricIssuerInfo implements Serializable {
  @ApiModelProperty("开票人")
  private String issuer;

  @ApiModelProperty("开票方式 ns-乐企 dppt-电票平台")
  private String issueType;

  @ApiModelProperty("在线标志,true:在线 false:不在线")
  private Boolean onlineFlag;

  @ApiModelProperty("实人认证标识（true-需要实人认证 false-已认证）")
  private Boolean needRealMeAuthFlag;

  @ApiModelProperty("上次登录时间(格式:yyyy-MM-dd HH:mm:ss.SSS)")
  private String lastLoginTime;

  @ApiModelProperty("上次实人认证时间(格式:yyyy-MM-dd HH:mm:ss.SSS)")
  private String lastRealMeAuthTime;

  private Boolean ableSwitchFlag;

  private Boolean manageMultiTaxNoFlag;
  
  @ApiModelProperty("开票人启用状态（enabled-启用 disabled-停用）")
  private String status;

}
