package com.xforceplus.seller.config.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class AllElectricIssuerInfoRecord implements Serializable {

    @ApiModelProperty("销方税号")
    @JsonProperty("taxNo")
    private String taxNo;

    @ApiModelProperty("销方公司名称")
    @JsonProperty("companyName")
    private String companyName;

    @ApiModelProperty("税号下的开票人")
    @JsonProperty("issuer")
    private String issuer;

    @ApiModelProperty("开票方式 ns-乐企 dppt-电票平台")
    private String issueType;

    @ApiModelProperty("在线标志,true:在线 false:不在线")
    private boolean loginState;

    @ApiModelProperty("实人认证标识（true：需要实人认证）")
    private Boolean needRealMeAuthFlag;

    @ApiModelProperty("唯一标识")
    private String uniqueKey;

    @ApiModelProperty("关联关系（0-无关联 1-已关联）")
    private Integer status;

    @ApiModelProperty("开票人启用状态（enabled-启用 disabled-停用）")
    private String issuerStatus;

    @ApiModelProperty("乐企标识")
    private Boolean isNaturalSystemFlag;

    @ApiModelProperty("上次登录时间(格式:yyyy-MM-dd HH:mm:ss.SSS)")
    private String lastLoginTime;

    @ApiModelProperty("上次实人认证时间(格式:yyyy-MM-dd HH:mm:ss.SSS)")
    private String lastRealMeAuthTime;

    private Boolean ableSwitchFlag;

    private Boolean manageMultiTaxNoFlag;

    public String convertUniqueKey(Long tenantId) {
        return String.format("%s-%s-%s-%s", tenantId, this.taxNo, this.issuer, this.issueType);
    }
}
