package com.xforceplus.seller.config.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;


@ApiModel(description = "null")

@JsonInclude(NON_NULL)
@Data
@ToString
public class ConfigSellerInfoEditRequest {

  @ApiModelProperty(value = "销方税号")
  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @ApiModelProperty(value = "销方名称")
  @JsonProperty("sellerName")
  private String sellerName = null;

  @ApiModelProperty(value = "销方地址")
  @JsonProperty("sellerAddress")
  private String sellerAddress = null;

  @ApiModelProperty(value = "销方电话")
  @JsonProperty("sellerTel")
  private String sellerTel = null;

  @ApiModelProperty(value = "销方银行名称")
  @JsonProperty("sellerBankName")
  private String sellerBankName = null;

  @ApiModelProperty(value = "销方银行账户")
  @JsonProperty("sellerBankAccount")
  private String sellerBankAccount = null;

  @ApiModelProperty(value = "业务单类型")
  @JsonProperty("salsebillType")
  private String salsebillType = null;

  @ApiModelProperty(value = "组织id")
  @JsonProperty("sysOrgId")
  private Long sysOrgId = null;

}
