package com.xforceplus.seller.config.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 邮件配置模型
 */
@JsonInclude(NON_NULL)
@Data
public class EmailConfigEntity implements Serializable {
    @JsonProperty("isDefault")
    private boolean isDefault;

    @JsonProperty("configId")
    private Long configId;

    @JsonProperty("autosend")
    private Boolean autosend;

    @JsonProperty("noticeType")
    private String noticeType;

    @JsonProperty("mailTemplateNo")
    private String mailTemplateNo;

    @JsonProperty("pickBizBillAddress")
    private Boolean pickBizBillAddress;

    @JsonProperty("pickUcAddress")
    private Boolean pickUcAddress;

    @JsonProperty("useCustomAddress")
    private Boolean useCustomAddress;

    @JsonProperty("customMails")
    private List<String> customMails;

    @JsonProperty("sendAtOnce")
    private Integer sendAtOnce;

    @JsonProperty("sendDaily")
    private Boolean sendDaily;

    @JsonProperty("sendTime")
    private String sendTime;

    @JsonProperty("monthSendTime")
    private String monthSendTime;

    @JsonProperty("sendMonthly")
    private Boolean sendMonthly;

    private String emailSender;

    private List<MsEnumBean> emailTemplate;

    @JsonProperty("phoneAutosend")
    private Boolean phoneAutosend;

    @JsonProperty("phoneSendAddressType")
    private Integer phoneSendAddressType;

    @JsonProperty("autoMerge")
    private Boolean autoMerge;

    @JsonProperty("phoneAutoMerge")
    private Boolean phoneAutoMerge;

    private List<String> emailAttach;

    @JsonProperty("emailMergeFields")
    private List<String> emailMergeFields;

    @JsonProperty("redInvoiceSendRule")
    private Integer redInvoiceSendRule;
}
