package com.xforceplus.seller.config.client.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class InitSettledConfigRequest {
    @ApiModelProperty("业务编号")
    private String businessNo;

    @ApiModelProperty("入驻类型(0:渠道入驻, 1:中心用户入驻, 2:中心用户税号加盟)")
    private Integer settledType;

    @ApiModelProperty("来源租户ID(中心租户Id/渠道在用户中心的租户ID)")
    private String sourceTenantId;

    @ApiModelProperty("购买信息")
    private BuyInfo buyInfo;

    @ApiModelProperty("入驻配置模版列表")
    private List<SettledConfig> settledConfigs;

    @ApiModelProperty("替换配置明细")
    private List<ReplaceConfigItem> replaceConfigItems;



    @Data
    public static class BuyInfo implements Serializable {
        @ApiModelProperty("租户ID")
        private Long tenantId;

        @ApiModelProperty("租户名称")
        private String tenantName;

        @ApiModelProperty("公司名称")
        private String companyName;

        @ApiModelProperty("公司税号")
        private String taxNum;

        @ApiModelProperty("公司ID")
        private Long companyId;

        @NotNull(message = "产品包代码列表 不能为空")
        @ApiModelProperty("产品包代码列表")
        private List<String> productCodes;

        @ApiModelProperty("创建用户ID")
        private Long createUserId;

        @ApiModelProperty("创建用户名称")
        private String createUserName;

        @ApiModelProperty("税号对应的组织code")
        private String orgCode;
        @ApiModelProperty("下级组织代码")
        private String subOrgCode;
    }
    @Data
    public static class SettledConfig implements Serializable {
        @ApiModelProperty("数据ID")
        private Long id;

        @ApiModelProperty("配置类型;0-通用配置 1-定制配置")
        private Integer configType;

        @ApiModelProperty("配置代码")
        private String configCode;

        @ApiModelProperty("配置分类")
        private String configClass;

        @ApiModelProperty("入驻类型")
        private Integer settledType;

        @ApiModelProperty("入驻租户id")
        private Long tenantId;

        @ApiModelProperty("入驻租户名称")
        private String tenantName;

        @ApiModelProperty("产品代码")
        private String productCode;

        @ApiModelProperty("产品名称")
        private String productName;

        @ApiModelProperty("单据类型")
        private String salesbillType;

        @ApiModelProperty("关联单据类型")
        private List<String> refSalesbillList;

        @ApiModelProperty("单据是否支持零售;0-非零售 1-零售")
        private Integer toCFlag;


        @ApiModelProperty("入驻描述")
        private String settledDesc;

        @ApiModelProperty("创建人id")
        private Long createUserId;

        @ApiModelProperty("创建人名称")
        private String createUserName;

        @ApiModelProperty("更新人id")
        private Long updateUserId;

        @ApiModelProperty("更新人名称")
        private String updateUserName;

        @ApiModelProperty("创建时间")
        private Date createTime;

        @ApiModelProperty("更新时间")
        private Date updateTime;

    }

    @Data
    public static class ReplaceConfigItem{
        @ApiModelProperty("模版类型")
        private Integer templateType;
        @ApiModelProperty("模版代码")
        private String templateCode;
        @ApiModelProperty("发票类型")
        private String invoiceType;
        @ApiModelProperty("国税来源")
        private String taxInvoiceSource;
        @ApiModelProperty("配置明细代码")
        private String itemCode;
        @ApiModelProperty("配置明细-值")
        private List<String> itemValue;
    }
}
