package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsConfigDeviceGetCompanyListRequest
 */

@JsonInclude(NON_NULL)
public class MsConfigDeviceGetCompanyListRequest {
  @JsonProperty("userId")
  private Long userId = null;

  @JsonIgnore
  public MsConfigDeviceGetCompanyListRequest userId(Long userId) {
    this.userId = userId;
    return this;
  }

   /**
   * 用户Id,不需要传,方便扩展生成对象
   * @return userId
  **/
  @ApiModelProperty(value = "用户Id,不需要传,方便扩展生成对象")
  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsConfigDeviceGetCompanyListRequest configDeviceGetCompanyListRequest = (MsConfigDeviceGetCompanyListRequest) o;
    return Objects.equals(this.userId, configDeviceGetCompanyListRequest.userId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsConfigDeviceGetCompanyListRequest {\n");
    
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
