package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.seller.config.client.model.MsDeviceQueryInfo;
import com.xforceplus.seller.config.client.model.MsPageInfo;
import com.xforceplus.seller.config.client.model.MsSortInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsConfigDeviceQueryRequest
 */

@JsonInclude(NON_NULL)
public class MsConfigDeviceQueryRequest {
  @JsonProperty("queryInfo")
  private MsDeviceQueryInfo queryInfo = null;

  @JsonProperty("pageInfo")
  private MsPageInfo pageInfo = null;

  @JsonProperty("sortInfo")
  private MsSortInfo sortInfo = null;

  @JsonProperty("isAppOrigin")
  private Boolean isAppOrigin = null;

  @JsonIgnore
  public MsConfigDeviceQueryRequest queryInfo(MsDeviceQueryInfo queryInfo) {
    this.queryInfo = queryInfo;
    return this;
  }

   /**
   * 查询信息
   * @return queryInfo
  **/
  @ApiModelProperty(value = "查询信息")
  public MsDeviceQueryInfo getQueryInfo() {
    return queryInfo;
  }

  public void setQueryInfo(MsDeviceQueryInfo queryInfo) {
    this.queryInfo = queryInfo;
  }

  @JsonIgnore
  public MsConfigDeviceQueryRequest pageInfo(MsPageInfo pageInfo) {
    this.pageInfo = pageInfo;
    return this;
  }

   /**
   * 分页信息
   * @return pageInfo
  **/
  @ApiModelProperty(value = "分页信息")
  public MsPageInfo getPageInfo() {
    return pageInfo;
  }

  public void setPageInfo(MsPageInfo pageInfo) {
    this.pageInfo = pageInfo;
  }

  @JsonIgnore
  public MsConfigDeviceQueryRequest sortInfo(MsSortInfo sortInfo) {
    this.sortInfo = sortInfo;
    return this;
  }

   /**
   * 排序信息
   * @return sortInfo
  **/
  @ApiModelProperty(value = "排序信息")
  public MsSortInfo getSortInfo() {
    return sortInfo;
  }

  public void setSortInfo(MsSortInfo sortInfo) {
    this.sortInfo = sortInfo;
  }

  @JsonIgnore
  public MsConfigDeviceQueryRequest isAppOrigin(Boolean isAppOrigin) {
    this.isAppOrigin = isAppOrigin;
    return this;
  }

   /**
   * 是否应用层请求来源,为true则微服务会从用户上下文获取租户Id
   * @return isAppOrigin
  **/
  @ApiModelProperty(value = "是否应用层请求来源,为true则微服务会从用户上下文获取租户Id")
  public Boolean getIsAppOrigin() {
    return isAppOrigin;
  }

  public void setIsAppOrigin(Boolean isAppOrigin) {
    this.isAppOrigin = isAppOrigin;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsConfigDeviceQueryRequest configDeviceQueryRequest = (MsConfigDeviceQueryRequest) o;
    return Objects.equals(this.queryInfo, configDeviceQueryRequest.queryInfo) &&
        Objects.equals(this.pageInfo, configDeviceQueryRequest.pageInfo) &&
        Objects.equals(this.sortInfo, configDeviceQueryRequest.sortInfo) &&
        Objects.equals(this.isAppOrigin, configDeviceQueryRequest.isAppOrigin);
  }

  @Override
  public int hashCode() {
    return Objects.hash(queryInfo, pageInfo, sortInfo, isAppOrigin);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsConfigDeviceQueryRequest {\n");
    
    sb.append("    queryInfo: ").append(toIndentedString(queryInfo)).append("\n");
    sb.append("    pageInfo: ").append(toIndentedString(pageInfo)).append("\n");
    sb.append("    sortInfo: ").append(toIndentedString(sortInfo)).append("\n");
    sb.append("    isAppOrigin: ").append(toIndentedString(isAppOrigin)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
