package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonInclude(NON_NULL)
public class MsConfigItemQueryRequest {
  @JsonProperty("configId")
  private String configId = null;

  private String sellerTaxNo;

  /**
   * 开票方税号
   */
  private String issuerTaxNo;

  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  public String getIssuerTaxNo() {
    return issuerTaxNo;
  }

  public void setIssuerTaxNo(String issuerTaxNo) {
    this.issuerTaxNo = issuerTaxNo;
  }

  @JsonIgnore
  public MsConfigItemQueryRequest configId(String configId) {
    this.configId = configId;
    return this;
  }
  /**
   * 配置项id
   * @return configId
  **/
  @ApiModelProperty(value = "配置项id")
  public String getConfigId() {
    return configId;
  }

  public void setConfigId(String configId) {
    this.configId = configId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsConfigItemQueryRequest configItemQueryRequest = (MsConfigItemQueryRequest) o;
    return Objects.equals(this.configId, configItemQueryRequest.configId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(configId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsConfigItemQueryRequest {\n");
    
    sb.append("    configId: ").append(toIndentedString(configId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
