package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.seller.config.client.model.MsUpdateTerminalInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsConfigUpdateTerminalRequest
 */

@JsonInclude(NON_NULL)
public class MsConfigUpdateTerminalRequest {
  @JsonProperty("terminalInfo")
  private MsUpdateTerminalInfo terminalInfo = null;

  @JsonIgnore
  public MsConfigUpdateTerminalRequest terminalInfo(MsUpdateTerminalInfo terminalInfo) {
    this.terminalInfo = terminalInfo;
    return this;
  }

   /**
   * 终端信息
   * @return terminalInfo
  **/
  @ApiModelProperty(value = "终端信息")
  public MsUpdateTerminalInfo getTerminalInfo() {
    return terminalInfo;
  }

  public void setTerminalInfo(MsUpdateTerminalInfo terminalInfo) {
    this.terminalInfo = terminalInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsConfigUpdateTerminalRequest configUpdateTerminalRequest = (MsConfigUpdateTerminalRequest) o;
    return Objects.equals(this.terminalInfo, configUpdateTerminalRequest.terminalInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(terminalInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsConfigUpdateTerminalRequest {\n");
    
    sb.append("    terminalInfo: ").append(toIndentedString(terminalInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
