package com.xforceplus.seller.config.client.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

@ApiModel("用户开票人（设备）关系信息查询请求返回信息")
public class MsConfigUserIssuerRelationData implements Serializable {
    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class MsConfigUserIssuerRelationConditionRequest implements Serializable {
        @ApiModelProperty("租户Id")
        private Long tenantId;
        @ApiModelProperty("用户Id")
        private Long userId;
        @ApiModelProperty("用户名称")
        private String userName;
        @ApiModelProperty("公司税号")
        private String taxNo;
        @ApiModelProperty("邮箱")
        private String email;
        @ApiModelProperty("手机号")
        private String mobile;
        @ApiModelProperty("状态")
        private Integer status;
        @ApiModelProperty("导入批次号")
        private Long importBatchNo;
        @ApiModelProperty("分页信息")
        private Page page;
    }
    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class UserIssuerRelationVo implements Serializable {
        @ApiModelProperty("手机账号")
        private String mobile;
        @ApiModelProperty("邮箱账号")
        private String email;
        @ApiModelProperty("用户名")
        private String userName;
        @ApiModelProperty("其它/域账号")
        private String accountName;
        @ApiModelProperty("开票人")
        private String issuer;
        @ApiModelProperty("公司名称")
        private String companyName;
        @ApiModelProperty("公司税号")
        private String taxNo;
        @ApiModelProperty("开票方式")
        private String issueType;
    }
}
