package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 查询自定义内容响应
 */
@ApiModel(description = "查询自定义内容响应")

@JsonInclude(NON_NULL)
public class MsCustomDefinitionResponse {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("result")
  private String result = null;

  @JsonIgnore
  public MsCustomDefinitionResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * 代码
   * @return code
  **/
  @ApiModelProperty(value = "代码")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsCustomDefinitionResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * 消息
   * @return message
  **/
  @ApiModelProperty(value = "消息")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsCustomDefinitionResponse result(String result) {
    this.result = result;
    return this;
  }

   /**
   * 自定义内容
   * @return result
  **/
  @ApiModelProperty(value = "自定义内容")
  public String getResult() {
    return result;
  }

  public void setResult(String result) {
    this.result = result;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCustomDefinitionResponse customDefinitionResponse = (MsCustomDefinitionResponse) o;
    return Objects.equals(this.code, customDefinitionResponse.code) &&
        Objects.equals(this.message, customDefinitionResponse.message) &&
        Objects.equals(this.result, customDefinitionResponse.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCustomDefinitionResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
