package com.xforceplus.seller.config.client.model;

import java.io.Serializable;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 元数据查询响应对象
 */
@ApiModel(description = "元数据查询响应对象")
@JsonInclude(NON_NULL)
public class MsGroupTypeBean implements Serializable {
  @JsonProperty("objId")
  private String objId = null;

  @JsonProperty("objType")
  private String objType = null;
  @JsonProperty("channel")
  private Long channel;
  @JsonProperty("objFlag")
  private Integer objFlag;

  @JsonIgnore
  public MsGroupTypeBean objId(String objId) {
    this.objId = objId;
    return this;
  }

   /**
   * 发起 1表示已受理 -1表示调用失败 查询 1表示处理完成 2表示处理中
   * @return objId
  **/
  @ApiModelProperty(value = "发起 1表示已受理 -1表示调用失败 查询 1表示处理完成 2表示处理中")
  public String getObjId() {
    return objId;
  }

  public void setObjId(String objId) {
    this.objId = objId;
  }

  @JsonIgnore
  public MsGroupTypeBean objType(String objType) {
    this.objType = objType;
    return this;
  }

   /**
   * return message
   * @return objType
  **/
  @ApiModelProperty(value = "return message")
  public String getObjType() {
    return objType;
  }

  public void setObjType(String objType) {
    this.objType = objType;
  }

  public Long getChannel() {
    return channel;
  }

  public void setChannel(Long channel) {
    this.channel = channel;
  }

  public Integer getObjFlag() {
    return objFlag;
  }

  public void setObjFlag(Integer objFlag) {
    this.objFlag = objFlag;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGroupTypeBean groupTypeBean = (MsGroupTypeBean) o;
    return Objects.equals(this.objId, groupTypeBean.objId) &&
        Objects.equals(this.objType, groupTypeBean.objType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(objId, objType);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGroupTypeBean {\n");
    
    sb.append("    objId: ").append(toIndentedString(objId)).append("\n");
    sb.append("    objType: ").append(toIndentedString(objType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
