package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.seller.config.client.model.MsBusinessObjMetadataBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 集团的下的业务类型，及业务类型下的所有元数据
 */
@ApiModel(description = "集团的下的业务类型，及业务类型下的所有元数据")

@JsonInclude(NON_NULL)
public class MsGroupTypeMetaDataDTO {
  @JsonProperty("objType")
  private String objType = null;

  @JsonProperty("metaList")
  private List<MsBusinessObjMetadataBean> metaList = new ArrayList<MsBusinessObjMetadataBean>();

  @JsonIgnore
  public MsGroupTypeMetaDataDTO objType(String objType) {
    this.objType = objType;
    return this;
  }

   /**
   * 业务类型
   * @return objType
  **/
  @ApiModelProperty(value = "业务类型")
  public String getObjType() {
    return objType;
  }

  public void setObjType(String objType) {
    this.objType = objType;
  }

  @JsonIgnore
  public MsGroupTypeMetaDataDTO metaList(List<MsBusinessObjMetadataBean> metaList) {
    this.metaList = metaList;
    return this;
  }

  public MsGroupTypeMetaDataDTO addMetaListItem(MsBusinessObjMetadataBean metaListItem) {
    this.metaList.add(metaListItem);
    return this;
  }

   /**
   * 元数据列表
   * @return metaList
  **/
  @ApiModelProperty(value = "元数据列表")
  public List<MsBusinessObjMetadataBean> getMetaList() {
    return metaList;
  }

  public void setMetaList(List<MsBusinessObjMetadataBean> metaList) {
    this.metaList = metaList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGroupTypeMetaDataDTO groupTypeMetaDataDTO = (MsGroupTypeMetaDataDTO) o;
    return Objects.equals(this.objType, groupTypeMetaDataDTO.objType) &&
        Objects.equals(this.metaList, groupTypeMetaDataDTO.metaList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(objType, metaList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGroupTypeMetaDataDTO {\n");
    
    sb.append("    objType: ").append(toIndentedString(objType)).append("\n");
    sb.append("    metaList: ").append(toIndentedString(metaList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
