package com.xforceplus.seller.config.client.model;

import java.io.Serializable;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonInclude(NON_NULL)
public class MsHighlightFieldDTO implements Serializable {
  @JsonProperty("fieldName")
  private String fieldName = null;

  @JsonProperty("relation")
  private String relation = null;

  @JsonProperty("text")
  private String text = null;

  @JsonIgnore
  public MsHighlightFieldDTO fieldName(String fieldName) {
    this.fieldName = fieldName;
    return this;
  }

   /**
   * 字段英文名
   * @return fieldName
  **/
  @ApiModelProperty(value = "字段英文名")
  public String getFieldName() {
    return fieldName;
  }

  public void setFieldName(String fieldName) {
    this.fieldName = fieldName;
  }

  @JsonIgnore
  public MsHighlightFieldDTO relation(String relation) {
    this.relation = relation;
    return this;
  }

   /**
   * 关系符号 inclusion-包含、eq-等于、gt-大于、lt-小于
   * @return relation
  **/
  @ApiModelProperty(value = "关系符号 inclusion-包含、eq-等于、gt-大于、lt-小于")
  public String getRelation() {
    return relation;
  }

  public void setRelation(String relation) {
    this.relation = relation;
  }

  @JsonIgnore
  public MsHighlightFieldDTO text(String text) {
    this.text = text;
    return this;
  }

   /**
   * 比较值
   * @return text
  **/
  @ApiModelProperty(value = "比较值")
  public String getText() {
    return text;
  }

  public void setText(String text) {
    this.text = text;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsHighlightFieldDTO highlightFieldDTO = (MsHighlightFieldDTO) o;
    return Objects.equals(this.fieldName, highlightFieldDTO.fieldName) &&
        Objects.equals(this.relation, highlightFieldDTO.relation) &&
        Objects.equals(this.text, highlightFieldDTO.text);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fieldName, relation, text);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsHighlightFieldDTO {\n");
    
    sb.append("    fieldName: ").append(toIndentedString(fieldName)).append("\n");
    sb.append("    relation: ").append(toIndentedString(relation)).append("\n");
    sb.append("    text: ").append(toIndentedString(text)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
